	PROGRAM LVTEST
C
C	LANGUAGE:  VAX-11 FORTRAN-77
C
C	OPERATING SYSTEM:  VAX/VMS
C
C	ORDER NUMBER:  12X-9XV
C
C	PART NUMBER:  000-025809-XXX REV. G  MAY, 1985
C
C	PRODUCT: VAX-11 DIAGNOSTIC,
C	PRODUCT: VAX/VMS DRIVER, SYMBIONT, AND OUTPUT PACKAGE
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C
C  PRINTER/PLOTTER DRIVER TEST PROGRAM
C
C************************************************
C*	+HISTORY+				*
C*						*
C*	DATE		REV	INIT.		*
C*						*
C*	10-30-80	A	D.L.W		*
C*						*
C*	12-18-81	B	D.L.W		*
C*						*
C*	 3-19-82	C	J.L.B		*
C*						*
C*	10-04-82	D	D.L.W		*
C*	1. Changes made to include spooling.	*
C*	2. Changes made to include output for	*
C*		VRC and REP products.		*
C*						*
C*	7-83		E	P.D.		*
C*	No changes to this module		*
C*						*
C*	7-84		F	B.L.		*
C*	1. Changed FORMAT 4 from I3 to I4	*
C*						*
C*	5-85		G	B.L.		*
C*	1. Increase size of buffers		*
C*	2. Change compressed test to work	*
C*		on REP with disk.		*
C*						*
C************************************************
C
	COMMON /IOCOM/ IUNIT,LUNIT,LREC,IOTYPE
C
C
	LOGICAL VRC,REP,ALL
	INTEGER*2 IPRINT(538),IPLOT(1076),IBIT15,IUPPER
	INTEGER*2 TYPE,TYPEUP,TEST,TESTUP
	INTEGER FORMFD
	BYTE INTHDR(26),ANS
	INTEGER*2 IT1(22),IT2(19),IT3(46),IT4(66),REPT(586),TEMP(586)
	INTEGER*2 REPT1(73),REPT2(72),REPT3(72),REPT4(72),REPT5(72),
	1	REPT6(72),REPT7(72),REPT8(72),REPT9(9)
	EQUIVALENCE (REPT1,REPT(1)),(REPT2,REPT(74)),(REPT3,REPT(146)),
	1	(REPT4,REPT(218)),(REPT5,REPT(290)),(REPT6,REPT(362)),
	2	(REPT7,REPT(434)),(REPT8,REPT(506)),(REPT9,REPT(578))
C
C... DEFINE VRC/REP TEST DATA
	DATA VRC/.FALSE./,REP/.FALSE./
C	DATA INTHDR/'18'X,'01'X,'00'X,'00'X,'18'X,'02'X,'00'X,
C	1	    '00'X,'18'X,'02'X,'00'X,'0E'X,'C0'X,'0A'X,
C	2	    '49'X,'44'X,' ',' ','L','V','T','E','S','T',
C	3	    'C2'X,'00'X/
	DATA INTHDR/"  30,"   1,"   0,"   0,"  30,"   2,"   0,
	1	    "   0,"  30,"   2,"   0,"  16," 300,"  12,
	2	    " 111," 104,' ',' ','L','V','T','E','S','T',
	3	    " 302,"   0/
C	DATA IT1/'1802'X,'0008'X,
C	1	 '8000'X,'0000'X,'0000'X,'0001'X,
C	2	 '1802'X,'0010'X,
C	3	 '0000'X,'0000'X,'0000'X,'0000'X,
C	4	 'FFFF'X,'0000'X,'0000'X,'0001'X,
C	5	 '1802'X,'0008'X,
C	6	 'FFFF'X,'0001'X,'0000'X,'0000'X/
	DATA IT1/" 14002,"    10,
	1	 "100000,"     0,"     0,"     1,
	2	 " 14002,"    20,
	3	 "     0,"     0,"     0,"     0,
	4	 "177777,"     0,"     0,"     1,
	5	 " 14002,"    10,
	6	 "177777,"     1,"     0,"     0/
C	DATA IBIT15,IUPPER/'8000'X,'DFDF'X/
	DATA IBIT15,IUPPER/"100000,"157737/
C	DATA IT2/'1802'X,'0006'X,'8100'X,'0000'X,'0000'X,
C	1	 '1802'X,'0006'X,'C080'X,'0000'X,'0100'X,
C	2	 '1802'X,'0006'X,'1000'X,'8008'X,'0100'X,
C	3	 '1802'X,'0004'X,'0000'X,'0300'X/
	DATA IT2/" 14002,"     6,"100400,"     0,"     0,
	1	 " 14002,"     6,"140200,"     0,"   400,
	2	 " 14002,"     6," 10000,"100010,"   400,
	3	 " 14002,"     4,"     0,"  1400/
C	DATA IT3/'1802'X,'0058'X,
C	1	 '8000'X,'0000'X,'0000'X,'0001'X,
C	2	 '0000'X,'0000'X,'00C8'X,'0000'X,
C	3	 '0000'X,'00C8'X,'00C8'X,'00C8'X,
C	4	 '0000'X,'00C8'X,'0000'X,'0000'X,
C	5	 '0000'X,'00C8'X,'0064'X,'012C'X,
C	6	 'FFFF'X,'0000'X,'0000'X,'0064'X,
C	7	 '0000'X,'012C'X,'0064'X,'00C8'X,
C	8	 'FFFF'X,'0000'X,'0000'X,'0064'X,
C	9	 '0000'X,'0000'X,'0000'X,'00C8'X,
C	1	 'FFFF'X,'0000'X,'0000'X,'0001'X,
C	2	 'FFFF'X,'0001'X,'0000'X,'0000'X/
	DATA IT3/" 14002,"   130,
	1	 "100000,"     0,"     0,"     1,
	2	 "     0,"     0,"   310,"     0,
	3	 "     0,"   310,"   310,"   310,
	4	 "     0,"   310,"     0,"     0,
	5	 "     0,"   310,"   144,"   454,
	6	 "177777,"     0,"     0,"   144,
	7	 "     0,"   454,"   144,"   310,
	8	 "177777,"     0,"     0,"   144,
	9	 "     0,"     0,"     0,"   310,
	1	 "177777,"     0,"     0,"     1,
	2	 "177777,"     1,"     0,"     0/
C	DATA IT4/'1802'X,'0080'X,
C	1	 '8000'X,'0000'X,'0000'X,'000A'X,
C	2	 'FFFF'X,'0000'X,'0000'X,'0001'X,
C	3	 '0000'X,'015E'X,'0000'X,'0032'X,
C	4	 '0000'X,'01C2'X,'0000'X,'02EE'X,
C	5	 '0000'X,'0190'X,'0000'X,'0190'X,
C	6	 '0000'X,'0190'X,'018F'X,'0190'X,
C	7	 '0000'X,'0190'X,'018F'X,'031F'X,
C	8	 '0000'X,'0190'X,'018F'X,'0001'X,
C	9	 '0000'X,'0190'X,'00C7'X,'0001'X,
C	1	 '0000'X,'0190'X,'018F'X,'00C8'X,
C	2	 '0000'X,'0190'X,'018F'X,'0258'X,
C	3	 '0000'X,'0190'X,'00C7'X,'031F'X,
C	4	 '0000'X,'0001'X,'018F'X,'0001'X,
C	5	 '0000'X,'031F'X,'018F'X,'031F'X,
C	6	 'FFFF'X,'0000'X,'0000'X,'0001'X,
C	7	 'FFFF'X,'0001'X,'0000'X,'0000'X/
	DATA IT4/" 14002,"   200,
	1	 "100000,"     0,"     0,"    12,
	2	 "177777,"     0,"     0,"     1,
	3	 "     0,"   536,"     0,"    62,
	4	 "     0,"   702,"     0,"  1356,
	5	 "     0,"   620,"     0,"   620,
	6	 "     0,"   620,"   617,"   620,
	7	 "     0,"   620,"   617,"  1437,
	8	 "     0,"   620,"   617,"     1,
	9	 "     0,"   620,"   307,"     1,
	1	 "     0,"   620,"   617,"   310,
	2	 "     0,"   620,"   617,"  1130,
	3	 "     0,"   620,"   307,"  1437,
	4	 "     0,"     1,"   617,"     1,
	5	 "     0,"  1437,"   617,"  1437,
	6	 "177777,"     0,"     0,"     1,
	7	 "177777,"     1,"     0,"     0/
C	DATA REPT1/'1802'X,'0490'X,
C	1	  '8300'X,'0000'X,'0000'X,
C	2	  '8101'X,'083F'X,'0000'X,'0000'X,
C	3	  '0320'X,'8000'X,'0320'X,'83F7'X,
C	4	  '0000'X,'83F7'X,'0000'X,'8000'X,
C	5	  '8B02'X,'0000'X,'0070'X,'0032'X,
C	6	  '0190'X,'890C'X,'0016'X,'522E'X,
C	7	  '452E'X,'502E'X,'2041'X,'4343'X,
C	8	  '4550'X,'5441'X,'4E43'X,'4520'X,
C	9	  '5445'X,'5354'X,'8714'X,'0001'X,
C	1	  '0000'X,'0010'X,'0010'X,'0001'X,
C	2	  '0002'X,'0004'X,'0008'X,'0010'X,
C	3	  '0020'X,'0040'X,'0080'X,'0100'X,
C	4	  '0200'X,'0400'X,'0800'X,'1000'X,
C	5	  '2000'X,'4000'X,'8000'X,'8714'X,
C	6	  '0002'X,'0000'X,'0010'X,'0010'X,
C	7	  '1C00'X,'2200'X,'4100'X,'4100'X,
C	8	  '4100'X,'2200'X,'1C00'X,'0000'X,
C	9	  '0041'X,'0022'X,'0014'X,'0008'X/
	DATA REPT1/" 14002,"  2220,
	1	  "101400,"     0,"     0,
	2	  "100401,"  1777,"     0,"     0,
	3	  "  1440,"100000,"  1440,"101767,
	4	  "     0,"101767,"     0,"100000,
	5	  "105402,"     0,"   160,"    62,
	6	  "   620,"104414,"    26," 51056,
	7	  " 42456," 50056," 20101," 41503,
	8	  " 42520," 52101," 47103," 42440,
	9	  " 52105," 51524,"103424,"     1,
	1	  "     0,"    20,"    20,"     1,
	2	  "     2,"     4,"    10,"    20,
	3	  "    40,"   100,"   200,"   400,
	4	  "  1000,"  2000,"  4000," 10000,
	5	  " 20000," 40000,"100000,"103424,
	6	  "     2,"     0,"    20,"    20,
	7	  " 16000," 21000," 40400," 40400,
	8	  " 40400," 21000," 16000,"     0,
	9	  "   101,"    42,"    24,"    10/
C	DATA REPT2/
C	1	  '0014'X,'0022'X,'0041'X,'0000'X,
C	2	  '8714'X,'0003'X,'0000'X,'0010'X,
C	3	  '0010'X,'8000'X,'4000'X,'2000'X,
C	4	  '1000'X,'0800'X,'0400'X,'0200'X,
C	5	  '0100'X,'0080'X,'0040'X,'0020'X,
C	6	  '0010'X,'0008'X,'0004'X,'0002'X,
C	7	  '0001'X,'8705'X,'003F'X,'0000'X,
C	8	  '0010'X,'0001'X,'0000'X,'0294'X,
C	9	  '00E1'X,'8D03'X,'003F'X,'0001'X,
C	1	  '0019'X,'0294'X,'0134'X,'8D03'X,
C	2	  '0001'X,'0001'X,'0019'X,'0294'X,
C	3	  '0187'X,'8D03'X,'0002'X,'0000'X,
C	4	  '0019'X,'0294'X,'01DA'X,'8D03'X,
C	5	  '0003'X,'0001'X,'0019'X,'00EE'X,
C	6	  '0064'X,'8D03'X,'003F'X,'0000'X,
C	7	  '000D'X,'0113'X,'0064'X,'8D03'X,
C	8	  '003F'X,'0001'X,'000D'X,'0139'X,
C	9	  '0064'X,'8D03'X,'003F'X,'0002'X/
	DATA REPT2/
	1	  "    24,"    42,"   101,"     0,
	2	  "103424,"     3,"     0,"    20,
	3	  "    20,"100000," 40000," 20000,
	4	  " 10000,"  4000,"  2000,"  1000,
	5	  "   400,"   200,"   100,"    40,
	6	  "    20,"    10,"     4,"     2,
	7	  "     1,"103405,"    77,"     0,
	8	  "    20,"     1,"     0,"  1224,
	9	  "   341,"106403,"    77,"     1,
	1	  "    31,"  1224,"   464,"106403,
	2	  "     1,"     1,"    31,"  1224,
	3	  "   607,"106403,"     2,"     0,
	4	  "    31,"  1224,"   732,"106403,
	5	  "     3,"     1,"    31,"   356,
	6	  "   144,"106403,"    77,"     0,
	7	  "    15,"   423,"   144,"106403,
	8	  "    77,"     1,"    15,"   471,
	9	  "   144,"106403,"    77,"     2/
C	DATA REPT3/
C	1	  '000D'X,'015E'X,'0064'X,'8D03'X,
C	2	  '003F'X,'0003'X,'000D'X,'0184'X,
C	3	  '0064'X,'8D03'X,'003F'X,'0004'X,
C	4	  '000D'X,'01A9'X,'0064'X,'8D03'X,
C	5	  '003F'X,'0005'X,'000D'X,'01CF'X,
C	6	  '0064'X,'8D03'X,'003F'X,'0006'X,
C	7	  '000D'X,'01F4'X,'0064'X,'8D03'X,
C	8	  '003F'X,'0007'X,'000D'X,'0064'X,
C	9	  '02EE'X,'0064'X,'8352'X,'8301'X,
C	1	  '0002'X,'007D'X,'02EE'X,'007D'X,
C	2	  '8352'X,'8301'X,'0003'X,'0096'X,
C	3	  '02EE'X,'0096'X,'8352'X,'8301'X,
C	4	  '0004'X,'00AF'X,'02EE'X,'00AF'X,
C	5	  '8352'X,'8301'X,'0001'X,'0190'X,
C	6	  '0320'X,'8D03'X,'003F'X,'0001'X,
C	7	  '0096'X,'8301'X,'0005'X,'0226'X,
C	8	  '8320'X,'8301'X,'0006'X,'0190'X,
C	9	  '0320'X,'021B'X,'8359'X,'8301'X/
	DATA REPT3/
	1	  "    15,"   536,"   144,"106403,
	2	  "    77,"     3,"    15,"   604,
	3	  "   144,"106403,"    77,"     4,
	4	  "    15,"   651,"   144,"106403,
	5	  "    77,"     5,"    15,"   717,
	6	  "   144,"106403,"    77,"     6,
	7	  "    15,"   764,"   144,"106403,
	8	  "    77,"     7,"    15,"   144,
	9	  "  1356,"   144,"101522,"101401,
	1	  "     2,"   175,"  1356,"   175,
	2	  "101522,"101401,"     3,"   226,
	3	  "  1356,"   226,"101522,"101401,
	4	  "     4,"   257,"  1356,"   257,
	5	  "101522,"101401,"     1,"   620,
	6	  "  1440,"106403,"    77,"     1,
	7	  "   226,"101401,"     5,"  1046,
	8	  "101440,"101401,"     6,"   620,
	9	  "  1440,"  1033,"101531,"101401/
C	DATA REPT4/
C	1	  '0007'X,'0190'X,'0320'X,'01FA'X,
C	2	  '838A'X,'8301'X,'0005'X,'0190'X,
C	3	  '0320'X,'01C9'X,'83AB'X,'8301'X,
C	4	  '0006'X,'0190'X,'0320'X,'0190'X,
C	5	  '83B6'X,'8301'X,'0007'X,'0190'X,
C	6	  '0320'X,'0157'X,'83AB'X,'8301'X,
C	7	  '0005'X,'0190'X,'0320'X,'0126'X,
C	8	  '838A'X,'8301'X,'0006'X,'0190'X,
C	9	  '0320'X,'0105'X,'8359'X,'8301'X,
C	1	  '0007'X,'0190'X,'0320'X,'00FA'X,
C	2	  '8320'X,'8301'X,'0005'X,'0190'X,
C	3	  '0320'X,'0105'X,'82E7'X,'8301'X,
C	4	  '0006'X,'0190'X,'0320'X,'0126'X,
C	5	  '82B6'X,'8301'X,'0007'X,'0190'X,
C	6	  '0320'X,'0157'X,'8295'X,'8301'X,
C	7	  '0005'X,'0190'X,'0320'X,'0190'X,
C	8	  '828A'X,'8301'X,'0006'X,'0190'X,
C	9	  '0320'X,'01C9'X,'8295'X,'8301'X/
	DATA REPT4/
	1	  "     7,"   620,"  1440,"   772,
	2	  "101612,"101401,"     5,"   620,
	3	  "  1440,"   711,"101653,"101401,
	4	  "     6,"   620,"  1440,"   620,
	5	  "101666,"101401,"     7,"   620,
	6	  "  1440,"   527,"101653,"101401,
	7	  "     5,"   620,"  1440,"   446,
	8	  "101612,"101401,"     6,"   620,
	9	  "  1440,"   405,"101531,"101401,
	1	  "     7,"   620,"  1440,"   372,
	2	  "101440,"101401,"     5,"   620,
	3	  "  1440,"   405,"101347,"101401,
	4	  "     6,"   620,"  1440,"   446,
	5	  "101266,"101401,"     7,"   620,
	6	  "  1440,"   527,"101225,"101401,
	7	  "     5,"   620,"  1440,"   620,
	8	  "101212,"101401,"     6,"   620,
	9	  "  1440,"   711,"101225,"101401/
C	DATA REPT5/
C	1	  '0007'X,'0190'X,'0320'X,'01FA'X,
C	2	  '82B6'X,'8301'X,'0005'X,'0190'X,
C	3	  '0320'X,'021B'X,'82E7'X,'8301'X,
C	4	  '0001'X,'8B02'X,'0000'X,'0050'X,
C	5	  '0064'X,'0226'X,'8904'X,'0005'X,
C	6	  '5448'X,'4943'X,'4B43'X,'8301'X,
C	7	  '0002'X,'007D'X,'0226'X,'8904'X,
C	8	  '0005'X,'5448'X,'4943'X,'4B43'X,
C	9	  '8301'X,'0003'X,'0096'X,'0226'X,
C	1	  '8904'X,'0005'X,'5448'X,'4943'X,
C	2	  '4B43'X,'8301'X,'0004'X,'00AF'X,
C	3	  '0226'X,'8904'X,'0005'X,'5448'X,
C	4	  '4943'X,'4B43'X,'8206'X,'0005'X,
C	5	  '0008'X,'0008'X,'0008'X,'0008'X,
C	6	  '0002'X,'8206'X,'0006'X,'0010'X,
C	7	  '0008'X,'0010'X,'0008'X,'0008'X,
C	8	  '8206'X,'0007'X,'0008'X,'0008'X,
C	9	  '0008'X,'0008'X,'000E'X,'8301'X/
	DATA REPT5/
	1	  "     7,"   620,"  1440,"   772,
	2	  "101266,"101401,"     5,"   620,
	3	  "  1440,"  1033,"101347,"101401,
	4	  "     1,"105402,"     0,"   120,
	5	  "   144,"  1046,"104404,"     5,
	6	  " 52110," 44503," 45503,"101401,
	7	  "     2,"   175,"  1046,"104404,
	8	  "     5," 52110," 44503," 45503,
	9	  "101401,"     3,"   226,"  1046,
	1	  "104404,"     5," 52110," 44503,
	2	  " 45503,"101401,"     4,"   257,
	3	  "  1046,"104404,"     5," 52110,
	4	  " 44503," 45503,"101006,"     5,
	5	  "    10,"    10,"    10,"    10,
	6	  "     2,"101006,"     6,"    20,
	7	  "    10,"    20,"    10,"    10,
	8	  "101006,"     7,"    10,"    10,
	9	  "    10,"    10,"    16,"101401/
C	DATA REPT6/
C	1	  '0005'X,'0064'X,'0064'X,'0064'X,
C	2	  '81F4'X,'8301'X,'0006'X,'007D'X,
C	3	  '0064'X,'007D'X,'81F4'X,'8301'X,
C	4	  '0007'X,'0096'X,'0064'X,'0096'X,
C	5	  '81F4'X,'8705'X,'0004'X,'0000'X,
C	6	  '0010'X,'0001'X,'0000'X,'8301'X,
C	7	  '0001'X,'0249'X,'02BC'X,'8807'X,
C	8	  '0004'X,'02AD'X,'82EE'X,'02AD'X,
C	9	  '828A'X,'0249'X,'82BC'X,'0249'X,
C	1	  '0320'X,'8805'X,'0001'X,'02AD'X,
C	2	  '0352'X,'02AD'X,'02EE'X,'0249'X,
C	3	  '0384'X,'8807'X,'0003'X,'02AD'X,
C	4	  '83B6'X,'02AD'X,'8352'X,'0249'X,
C	5	  '8384'X,'00FA'X,'023F'X,'8807'X,
C	6	  '0003'X,'012C'X,'8226'X,'012C'X,
C	7	  '8258'X,'00FA'X,'823F'X,'8301'X,
C	8	  '0002'X,'0177'X,'0226'X,'8807'X,
C	9	  '0003'X,'0177'X,'8258'X,'0145'X/
	DATA REPT6/
	1	  "     5,"   144,"   144,"   144,
	2	  "100764,"101401,"     6,"   175,
	3	  "   144,"   175,"100764,"101401,
	4	  "     7,"   226,"   144,"   226,
	5	  "100764,"103405,"     4,"     0,
	6	  "    20,"     1,"     0,"101401,
	7	  "     1,"  1111,"  1274,"104007,
	8	  "     4,"  1255,"101356,"  1255,
	9	  "101212,"  1111,"101274,"  1111,
	1	  "  1440,"104005,"     1,"  1255,
	2	  "  1522,"  1255,"  1356,"  1111,
	3	  "  1604,"104007,"     3,"  1255,
	4	  "101666,"  1255,"101522,"  1111,
	5	  "101604,"   372,"  1077,"104007,
	6	  "     3,"   454,"101046,"   454,
	7	  "101130,"   372,"101077,"101401,
	8	  "     2,"   567,"  1046,"104007,
	9	  "     3,"   567,"101130,"   505/
C	DATA REPT7/
C	1	  '823F'X,'0177'X,'8226'X,'8301'X,
C	2	  '0003'X,'01C2'X,'0226'X,'8807'X,
C	3	  '0003'X,'01C2'X,'8258'X,'0190'X,
C	4	  '823F'X,'01C2'X,'8226'X,'8301'X,
C	5	  '0004'X,'01DB'X,'023F'X,'8807'X,
C	6	  '0003'X,'020D'X,'8226'X,'020D'X,
C	7	  '8258'X,'01DB'X,'823F'X,'8301'X,
C	8	  '0005'X,'0226'X,'023F'X,'8807'X,
C	9	  '0003'X,'0258'X,'8226'X,'0258'X,
C	1	  '8258'X,'0226'X,'823F'X,'0190'X,
C	2	  '015E'X,'8D03'X,'003F'X,'0001'X,
C	3	  '0096'X,'8301'X,'0001'X,'8B02'X,
C	4	  '0050'X,'0000'X,'0190'X,'015E'X,
C	5	  '8907'X,'000C'X,'2020'X,'4143'X,
C	6	  '4345'X,'5054'X,'414E'X,'4345'X,
C	7	  '8B02'X,'0038'X,'0038'X,'0190'X,
C	8	  '015E'X,'8907'X,'000C'X,'2020'X,
C	9	  '4143'X,'4345'X,'5054'X,'414E'X/
	DATA REPT7/
	1	  "101077,"   567,"101046,"101401,
	2	  "     3,"   702,"  1046,"104007,
	3	  "     3,"   702,"101130,"   620,
	4	  "101077,"   702,"101046,"101401,
	5	  "     4,"   733,"  1077,"104007,
	6	  "     3,"  1015,"101046,"  1015,
	7	  "101130,"   733,"101077,"101401,
	8	  "     5,"  1046,"  1077,"104007,
	9	  "     3,"  1130,"101046,"  1130,
	1	  "101130,"  1046,"101077,"   620,
	2	  "   536,"106403,"    77,"     1,
	3	  "   226,"101401,"     1,"105402,
	4	  "   120,"     0,"   620,"   536,
	5	  "104407,"    14," 20040," 40503,
	6	  " 41505," 50124," 40516," 41505,
	7	  "105402,"    70,"    70,"   620,
	8	  "   536,"104407,"    14," 20040,
	9	  " 40503," 41505," 50124," 40516/
C	DATA REPT8/
C	1	  '4345'X,'8B02'X,'0000'X,'0050'X,
C	2	  '0190'X,'015E'X,'8907'X,'000C'X,
C	3	  '2020'X,'4143'X,'4345'X,'5054'X,
C	4	  '414E'X,'4345'X,'8B02'X,'FFC8'X,
C	5	  '0038'X,'0190'X,'015E'X,'8907'X,
C	6	  '000C'X,'2020'X,'4143'X,'4345'X,
C	7	  '5054'X,'414E'X,'4345'X,'8B02'X,
C	8	  'FFB0'X,'0000'X,'0190'X,'015E'X,
C	9	  '8907'X,'000C'X,'2020'X,'4143'X,
C	1	  '4345'X,'5054'X,'414E'X,'4345'X,
C	2	  '8B02'X,'FFC8'X,'FFC8'X,'0190'X,
C	3	  '015E'X,'8907'X,'000C'X,'2020'X,
C	4	  '4143'X,'4345'X,'5054'X,'414E'X,
C	5	  '4345'X,'8B02'X,'0000'X,'FFB0'X,
C	6	  '0190'X,'015E'X,'8907'X,'000C'X,
C	7	  '2020'X,'4143'X,'4345'X,'5054'X,
C	8	  '414E'X,'4345'X,'8B02'X,'0038'X,
C	9	  'FFC8'X,'0190'X,'015E'X,'8907'X/
	DATA REPT8/
	1	  " 41505,"105402,"     0,"   120,
	2	  "   620,"   536,"104407,"    14,
	3	  " 20040," 40503," 41505," 50124,
	4	  " 40516," 41505,"105402,"177710,
	5	  "    70,"   620,"   536,"104407,
	6	  "    14," 20040," 40503," 41505,
	7	  " 50124," 40516," 41505,"105402,
	8	  "177660,"     0,"   620,"   536,
	9	  "104407,"    14," 20040," 40503,
	1	  " 41505," 50124," 40516," 41505,
	2	  "105402,"177710,"177710,"   620,
	3	  "   536,"104407,"    14," 20040,
	4	  " 40503," 41505," 50124," 40516,
	5	  " 41505,"105402,"     0,"177660,
	6	  "   620,"   536,"104407,"    14,
	7	  " 20040," 40503," 41505," 50124,
	8	  " 40516," 41505,"105402,"    70,
	9	  "177710,"   620,"   536,"104407/
C	DATA REPT9/
C	1	  '000C'X,'2020'X,'4143'X,'4345'X,
C	2	  '5054'X,'414E'X,'4345'X,'8000'X,
C	3	  'C200'X/
	DATA REPT9/
	1	  "    14," 20040," 40503," 41505,
	2	  " 50124," 40516," 41505,"100000,
	3	  "141000/
	DATA IPRINT/538*'AZ'/,IPLOT/1076*-256/
	DATA FORMFD/4/
	DATA LUNIT/5/
    1	FORMAT (' Printer/Plotter type?'//,
     X          '	Printer only = PR'/,
     X          '	Plotter only = PL'/,
     X          '	Printer/Plotter = PP'//,
     X          '$Enter Printer/Plotter type: ')
    2	FORMAT (A2)
    3	FORMAT ('$Enter columns/line = ')
    4	FORMAT (I4)
    5	FORMAT ('$Enter number of bytes/scan = ')
   11	FORMAT ('$VRC Present (Y or N)? ')
   12	FORMAT (A1)
   13   FORMAT ('$Enter Plotter Density: ')
   14	FORMAT ('$REP Present (Y or N)? ')
   15	FORMAT (' Remember to set VRC to non-swap mode (see manual)')
   20	FORMAT ('$Enter test code, ? for help:   ')
   50	FORMAT (' PR--Printer test, alternating A and Z')
   51	FORMAT (' PL--Plotter test, 200 bars of every other byte on')
   52	FORMAT (' PP--Print/Plot test, combination of PR and PL')
   53	FORMAT (' V1--VRC test 1, sail plot with vectors')
   54	FORMAT (' V2--VRC test 2, sail with compressed data')
   55	FORMAT (' V3--VRC test 3, house plot')
   56	FORMAT (' V4--VRC test 4, 9 possible vectors')
   57	FORMAT (' RE--REP test, R. E. P. acceptance test')
   58	FORMAT (' AL--All tests applicable to this system')
   59	FORMAT (' EX--Exit this program')
C
	IOTYPE = 0
	CALL ATTACH
C
	TYPE 1
	ACCEPT 2,TYPE
C
C...	CONVERT TO UPPER CASE
	TYPEUP = TYPE .AND. IUPPER
	IF (TYPEUP .EQ. 'PL') GO TO 110
C
C...	GET PRINTER CHARACTERISTICS
	TYPE 3
	ACCEPT 4,NCHARS
	IF (TYPEUP .EQ. 'PR') GO TO 200
C
C...	GET PLOTTER CHARACTERISTICS
110	TYPE 5
	ACCEPT 4,NBYTES
C
C... DETERMINE NUMBER OF BITS PER SCAN
	NBITS = NBYTES * 8
C
C... DETERMINE IF VRC PRESENT
115	TYPE 11
	ACCEPT 12,ANS
	IF ((ANS .EQ. 'N') .OR.  (ANS .EQ. 'n')) GO TO 120
	IF ((ANS .NE. 'Y') .AND. (ANS .NE. 'y')) GO TO 115
	VRC = .TRUE.
	TYPE 15
	GOTO 125
C
C... DETERMINE IF REP PRESENT
120	TYPE 14
	ACCEPT 12,ANS
	IF ((ANS .EQ. 'N') .OR. (ANS .EQ. 'n')) GO TO 200
	IF ((ANS .NE. 'Y') .AND. (ANS .NE. 'y')) GOTO 120
	VRC = .TRUE.
	REP = .TRUE.
125	TYPE 13
	ACCEPT 4,IDENS
C
C... FIND OUT WHICH TEST REQUESTED
200	TYPE 20
	ACCEPT 2,TEST
C
C...	CONVERT TO UPPER CASE
	TESTUP = TEST .AND. IUPPER
	ALL = .FALSE.
	IF (TESTUP .EQ. 'PR' .AND. TYPEUP .NE. 'PL') GO TO 300
	IF (TESTUP .EQ. 'PL' .AND. TYPEUP .NE. 'PR') GO TO 500
	IF (TESTUP .EQ. 'PP' .AND. TYPEUP .EQ. 'PP') GO TO 650
	IF (((TEST.EQ.'V1') .OR. (TEST.EQ.'v1')) .AND. VRC) GO TO 800
	IF (((TEST.EQ.'V2') .OR. (TEST.EQ.'v2')) .AND. VRC) GO TO 812
	IF (((TEST.EQ.'V3') .OR. (TEST.EQ.'v3')) .AND. VRC) GO TO 850
	IF (((TEST.EQ.'V4') .OR. (TEST.EQ.'v4')) .AND. VRC) GO TO 860
	IF (TESTUP .EQ. 'RE' .AND. REP) GO TO 870
	IF (TESTUP .EQ. 'EX') GO TO 999
	IF (TESTUP .EQ. 'AL') GO TO 250
	IF (TEST .NE. '? ') GO TO 200
	TYPE 50
	TYPE 51
	TYPE 52
	TYPE 53
	TYPE 54
	TYPE 55
	TYPE 56
	TYPE 57
	TYPE 58
	TYPE 59
	GO TO 200
250	ALL = .TRUE.
C
C... IF PLOTTER ONLY GO AROUND PRINT TEST
	IF (TYPEUP .EQ. 'PL') GO TO 500
C
C...	PRINT TEST
  300	TYPE 50
	IOTYPE = 0
	DO 400 I=1,10
	CALL OUTPUT (IPRINT,NCHARS)
  400	CONTINUE
	CALL OUTPUT (FORMFD,0)
	IF (.NOT. ALL) GO TO 200
	IF (TYPEUP .EQ. 'PR') GO TO 200
C
C...	PLOT TEST
  500	TYPE 51
	IOTYPE = 1
	DO 600 I=1,200
	CALL OUTPUT (IPLOT,NBYTES)
  600	CONTINUE
	CALL OUTPUT (FORMFD,0)
	IF (.NOT. ALL) GO TO 200
	IF (TYPEUP .EQ. 'PL') GO TO 800
C
C...	PRINT/PLOT TEST
  650	TYPE 52
	DO 700 I=1,10
	IOTYPE = 0
	CALL OUTPUT (IPRINT,NCHARS)
	IOTYPE = 1
	DO 700 J=1,20
	CALL OUTPUT (IPLOT,NBYTES)
  700	CONTINUE
	CALL OUTPUT (FORMFD,0)
	IF (.NOT. ALL) GO TO 200
  800	IF (.NOT. VRC) GOTO 200
C
C... VRC/REP SAIL PLOT WITH VECTORS
	TYPE 53
C
C... INDICATE PRINT OUTPUT, NO SWAPPING
	IOTYPE = 0
C
C... OUTPUT INIT HEADER
	CALL OUTPUT(INTHDR,26)
C
C... SET DENSITY
	IT1(4) = IDENS
C
C... SET BYTES/SCAN
	IT1(5) = NBYTES
C
C... INDICATE VECTOR DATA TO FOLLOW, SWAP BYTES
	IOTYPE = 256
	DO 802 J = 1,6
  802	TEMP(J) = IT1(J)
	CALL OUTPUT(TEMP,12)
C
C... INITILIZE VECTOR
	IT1(12) = NBITS - 1
C
C... PLOT A SAIL
	DO 810 I = 1,NBITS
C
C... COPY TO TEMPORARY BUFFER
	   DO 805 J=1,10
805	   TEMP(J)=IT1(J+6)
C
C... PLOT ONE SCAN
	   CALL OUTPUT(TEMP,20)
C
C... WAIT FOR OUTPUT TO COMPLETE
	   CALL OWAIT
C
C... ONE LESS BIT PER SCAN
	   IT1(12) = IT1(12) - 1
  810	CONTINUE
C
C... TERMINATE PLOT
	DO 811 J = 1,6
811	TEMP(J) = IT1(J+16)
	CALL OUTPUT(TEMP,12)
C
C... WAIT FOR COMPLETION
	CALL OWAIT
	IF (.NOT. ALL) GO TO 200
C
C... PLOT TWO, SAIL WITH COMPRESSED DATA
C
C... OUTPUT INIT HEADER, NO BYTE SWAPPING
812	TYPE 54
	IOTYPE=0
	CALL OUTPUT(INTHDR,26)
C
C... INITIALIZE DENSITY AND BYTES/SCAN, AND START COMPRESSED RASTER
	IT2(4) = IDENS
	IT2(5) = NBYTES
C
C... COPY TO TEMPORARY BUFFER
	DO 813 J=1,5
813	TEMP(J)=IT2(J)
C
C... OUTPUT BUFFER WITH SWAP BYTES
	IOTYPE=256
	CALL OUTPUT(TEMP,10)
C
C... INITIALIZE DATA
C	IT2(8) = 'C080'X
	IT2(8) = "140200
	IS = 5
C
C... OUTPUT COMPRESSED SAIL PLOT
	DO 840 I = 1,NBITS
C
C... USE RASTER BYTE FOR FIRST 7 SCANS, OTHERWISE USE LONG RUN
	IF (I-8) 815,820,825
815	IT2(8) = IT2(8) .OR. (2**(8-I))
	GO TO 830
820	IS = 10
825	IT2(14) = I
	IT2(14) = IT2(14) .OR. IBIT15
C
C... COPY TO TEMPORARY BUFFER
830	DO 835 J = 1,5
835	TEMP(J) = IT2(IS + J)
C
C... OUTPUT BUFFER WITH SWAP BYTES
	CALL OUTPUT(TEMP,10)
C
C... WAIT FOR I/O COMPLETION
	CALL OWAIT
840	CONTINUE
C
C... OUTPUT END-OF-PLOT
	DO 845 J = 1,4
845	TEMP(J) = IT2(J + 15)
	CALL OUTPUT (TEMP,8)
	CALL OWAIT
	IF (.NOT. ALL) GO TO 200
C
C... PLOT THREE HOUSE PLOT
C
C... OUTPUT INIT HEADER, NO BYTE SWAPPING
850	TYPE 55
	IOTYPE=0
	CALL OUTPUT(INTHDR,26)
C
C... INITIALIZE DENSITY
	IT3(4) = IDENS
C
C... INITIALIZE BYTES/SCAN
	IT3(5) = NBYTES
C
C... SET SWAP BYTES FLAG
	IOTYPE = 256
C
C... OUTPUT VECTORS FOR HOUSE
	DO 855 J = 1,46
  855	TEMP(J) = IT3(J)
	CALL OUTPUT(TEMP,92)
C
C... WAIT FOR COMPLETION
	CALL OWAIT
	IF (.NOT. ALL) GO TO 200
C
C... PLOT FOUR 9 POSSIBLE VECTORS
C
C... OUTPUT INIT HEADER, NO BYTE SWAPPING
860	TYPE 56
	IOTYPE=0
	CALL OUTPUT(INTHDR,26)
C
C... INITIALIZE DENSITY
	IT4(4) = IDENS
C
C... INITIALIZE BYTES/SCAN
	IT4(5) = NBYTES
C
C... SET SWAP BYTES FLAG
	IOTYPE=256
C
C... OUTPUT 9 VECTOR TYPES
	DO 865 J = 1,66
  865	TEMP(J) = IT4(J)
	CALL OUTPUT(TEMP,132)
C
C... WAIT FOR COMPLETION
	CALL OWAIT
C
C... DETERMINE IF REP TEST NEEDED
	IF (.NOT. ALL) GO TO 200
	IF (.NOT.REP) GOTO 200
C
C... OUTPUT INIT HEADER, NO BYTE SWAPPING
870	TYPE 57
	IOTYPE=0
	CALL OUTPUT(INTHDR,26)
C
C... INITIALIZE DENSITY
	REPT(4) = IDENS
C
C... INITIALIZE BYTES/SCAN
	REPT(5) = NBYTES
C
C... SWAP REP TEST DATA
	IOTYPE=256
C
C... OUTPUT REP TEST PLOT
	DO 875 J = 1,586
875	TEMP(J) = REPT(J)
	CALL OUTPUT(TEMP,1172)
C
C... WAIT FOR COMPLETION
	CALL OWAIT
	GO TO 200
C
C... DETACH OUTPUT DEVICE
  999	CALL OUTPUT (FORMFD,0)
	CALL OWAIT
	CALL DETACH
	STOP 'End of Printer/Plotter Test'
	END
