%endoflist  { do not output translated C code }
%control 1

! THIS FILE *MUST* BE KEPT IN SYNC WITH perms.h and perms.c

! These prims are a mixture of prims from multiple systems, in an attempt
! to be backward compatible with as many Imp environments as possible.
! Unfortunately a small number of library calls are incompatible between
! versions; specifically PRINT and PRINT FL which in one incarnation
! have one argument for places and in another have two.  It's marginally
! possible to support both using either stdargs, or the C11 support for 
! varadic macros.

! How it all works: this file does not cause any C code to be output - the
! C output only starts on %endofperm ... this exists only to get the declarations
! into the symbol table for use by the program that follows.  When the generated
! C is compiled, it includes perms.h instead, which affords us the opportunity
! to do some tricks with the C pre-processor etc which come in handy for
! handling signals for example.

! procedures declared as %perm or %prim are treated similarly to standard
! external routines, except that they are declared at an outer level of scope
! and can therefore be superceded by a user-written top-level procedure.

! %perm routines are just normal routines as far as the translation to C
! is concerned - but %prim routines are often implemented by code in the compiler
! itself and there may be no actual body for these procedures (although
! there *can* be, in addition to generated code). They can also be implemented
! by macro calls or C's "inline" procedures from within perm.h.

! Note also that %systemroutine procedures are *C* externals, not ones
! written in Imp - the primary difference (apart from trivial name issues)
! is that C procedures evaluate their parameters in right-to-left order
! as opposed to Imp which is defined as evaluating parameters from left-to-right.

! %external routines obey the system calling conventions and are exported from
! object files with the same names as declared in Imp.  %perm/%prim/%system
! declarations however - if they generate external linkage - modify the exported
! name so that a prefix is added.  This allows Imp code to be linked with C
! code while avoid name clashes caused by internal imp procedures with the
! same names as system procedures such as "write" on linux.  To access an
! imp procedure when a system procedure of the same name also has to be accessible,
! create a new declaration for the Imp version, using an alias, such as
! %externalroutine impwrite %alias "_imp_write" (%integer n, p) and call
! impwrite(num, places) instead of write(num, places) because a call to
! unadorned write() will get the system one instead.  (You will of course
! have to write a %spec for that or %include some header file such as "linux.inc"

! specs for system calls such as on linux should mirror the C versions.  Sometimes
! a shim procedure will have to be written if, for example, the system procedure
! takes a C style 0-terminated string as a parameter but the Imp program is
! working with Imp style strings wihich have a preceding length byte.  Normal
! users should never need to reverse the order of parameters to cross-call
! library code.

%constlongreal          PI = 3.141592653589793238462  ;! Could replace with a realfn?
%constinteger           nl = 10
%conststring(1)         snl = "
"
!%constname             nil == 0  ;! not sure if this syntax will work...



! %prim routines are implemented by the compiler with the equivalent of inline code
! %perm routines are implemented by 'static inline' defininitions in perms.h
! Calls to C library code are implemented via '%systemroutinespec' in order
! to allow i2c to force correct C external linkage and order of parameter evaluation.
! Calls to library code written in imp use standard '%externalroutine's.


%primlongrealfnspec     float(%long %real n)  ;! not %integer parameter - relies on compiler promoting int to double when assigning to a %real
%primstring(1)%fnspec   tostring(%integer c)

! on a 64-bit system this will need to return a %longinteger
%primintegerfnspec      addr(%name p)

! any parameter which has to represent an address should also
! be a %longinteger once 64-bit architectures are supported.
! I've been considering adding a %address type which would be
! treated like an integer of the appropriate size - but for
! the imptoc project, not i2c (icode to c), because we are
! stuck with the imp77 parser for i2c which is not readily modifiable.

! (and for compiling pre-64bit code, we probably need to invent
! a "%integers %long" statement!)

{ 8 bits }
%primbyteintegermapspec     byte(%integer n)
%primbyteintegermapspec     byteinteger(%integer n)
{ 16 bits }
%primshortintegermapspec    short(%integer n)
%primshortintegermapspec    shortinteger(%integer n)
{ 32 bits }
%primintegermapspec         integer(%integer n)
{ 64 bits }
%primlongintegermapspec     longinteger(%integer n)
{ 128 bits }
%primlonglongintegermapspec longlonginteger(%integer n)
%primlonglongintegerfnspec  lengtheni(%integer i)
{ 32 bits }
%primrealmapspec            real(%integer n)
{ 64 bits }
%primlongrealmapspec        longreal(%integer n)
! { 128 bits }
!%primlonglongrealmapspec    longlongreal(%integer n)
{ 255 bytes }
%primstring(*)%mapspec      string(%integer n)
%primrecord(*)%mapspec      record(%integer n)

! These two should be changed to %string (*) %name s if Imp semantics of
! assigning to the length byte are to be supported.  The definitions below
! do not legitimately support changing the length of the string value parameter!
%primbyteintegermapspec     length(%string(*)%name s)
%primbyteintegermapspec     charno(%string(*)%name s,%integer n)


%primintegerfnspec        typeof(%name n)

! This function returns a code which indicates the type of the
! object supplied as parameter.  The complete list of code values
! which may be returned by TYPE OF is as follows:
!
! 0 - unknown type
! 1 - integer
! 2 - real
! 3 - string
! 4 - record
! 5 - byte integer
! 6 - short integer
! 7 - long integer
! 8 - long real
! 9 - array
! 10 - label
!
! Note that an actual runtime call will be necessary in the case of
! %name parameters, but for known variables, the type information can
! be supplied by the compiler directly.  So, a prim/perm hybrid.
!

%primintegerfnspec        sizeof(%name n)

! similar observations as per typeof above.  The %name parameter
! problem however requires that %name parameters are passed as
! a struct containing the desired address in addition to the
! type and size information.  That descriptor has to be able
! to handle strings and records.

! Some of the perm routines can be implemented by passing the buck
! to C library routines.  To future-proof this a little I am specifying
! all calls to the C library as %systemroutine rather than %externalroutine.

! Note that the C library supports multiple versions of some of these
! calls depending on the parameter and result type.

%systemlongrealfnspec     arcsin  %alias "asin"  (%longreal angle)
%systemlongrealfnspec     arccos  %alias "acos"  (%longreal angle)
%systemlongrealfnspec     arctan  %alias "atan"  (%longreal x,y)
%systemlongrealfnspec     arctan1 %alias "atan1" (%longreal angle)

%systemlongrealfnspec     sin(%longreal angle)
%systemlongrealfnspec     cos(%longreal angle)
%systemlongrealfnspec     tan(%longreal angle)

%permlongrealfnspec       fraction(%longreal r)
%permlongrealfnspec       frac pt(%longreal r)

%permintegerfnspec        imod(%integer i)
%permlongrealfnspec       mod(%longreal r)

%permintegerfnspec        int(%longreal r)
%permintegerfnspec        int pt(%longreal r)

%permlongintegerfnspec    lint(%longreal r)
%permlongintegerfnspec    lint pt(%longreal r)

%permintegerfnspec        trunc(%longreal r)
%permintegerfnspec        round(%longreal r)

%permlongintegerfnspec    iexp(%integer num, power)
%permlongrealfnspec       rexp(%longreal num, power)

%permlongrealfnspec       log(%longreal X)
%primintegerfnspec        rem(%integer p,q)
%systemlongrealfnspec     sqrt(%longreal num)
%systemintegerfnspec      isqrt(%longreal num)
%permintegerfnspec        mul div(%integer A, B, C )

! Perms are roughly equivalent to externals at level -1, however
! they *may* be implemented by macros.  Therefore Perms should not
! be assumed to usable as procedure parameters - if needed, the
! traditional method is to wrap them in another procedure.

%permroutinespec          prompt(%string(15) s)

! read symbol and read ch *should* take a non-specific %name parameter but
! until I implement those properly, %integername is preferable to %byteintegername...
%permroutinespec          read symbol(%integername p)
                            { *not* %byteintegername, which may cause problems }
%permroutinespec          read ch(%integername p)

%permintegerfnspec        next symbol  { 'symbol' does cr/lf filtering if appropriate }
%permintegerfnspec        next ch      { whereas 'ch's are raw and may return CR }
%permroutinespec          skip symbol
%permroutinespec          print symbol(%byteinteger sym)
%permroutinespec          print ch(%byteinteger sym)
%permroutinespec          print string(%string(255)  s)
%permroutinespec          write(%integer  v,p)

! "item"s are just 1-character strings.
%externalroutinespec      read item(%string(*)%name s)
%externalroutinespec      read string(%string(*)%name s)
%externalroutinespec      read text(%string(*)%name s,%integer delim)
%externalstring(255)%fnspec next item
%permroutinespec          read line(%string(*)%name s)

! some redundancy in some of the procedure names to accommodate the many various
! implementations of IMP throughout the years.

%permintegerfnspec        instream
%permintegerfnspec        outstream
%permintegerfnspec        input stream
%permintegerfnspec        output stream
%permstring(255)%fnspec   input name
%permstring(255)%fnspec   output name
%permstring(255)%fnspec   in file name
%permstring(255)%fnspec   out file name
%permroutinespec          select input(%integer  n)
%permroutinespec          select output(%integer  n)
%permroutinespec          open input(%integer  n, %string(255) fd)
%permroutinespec          open output(%integer  n,%string(255) fd)
%permroutinespec          open binary input(%integer  n, %string(255) fd)
%permroutinespec          open binary output(%integer  n,%string(255) fd)
%permroutinespec          define input(%integer i,%string(255) spec)
%permroutinespec          define output(%integer i,%string(255) spec)
%permroutinespec          abandon input
%permroutinespec          abandon output
%permroutinespec          close input
%permroutinespec          close output
%permroutinespec          reset input
%permroutinespec          reset output
%permroutinespec          complete input
%permroutinespec          complete output
%permroutinespec          position input(%integer p)
%permroutinespec          position output(%integer p)
%permroutinespec          input position
%permroutinespec          output position
%permpredicatespec        end of input
%permroutinespec          space
%permroutinespec          spaces(%integer  n)
%externalroutinespec      newpage
%permroutinespec          newline
%permroutinespec          newlines(%integer n)
%permroutinespec          read(%name ptr)
%permroutinespec          print(%longreal r, %integer before, %integer after)
%permroutinespec          print floating(%longreal r, %integer a, b)
%permroutinespec          print fl(%longreal r, %integer places)
%permroutinespec	  to upper(%string(*)%name s)
%permroutinespec	  to lower(%string(*)%name s)
%permstring(255)%fnspec   sub string(%string(255) s, %integer from, to)
%permstring(255)%fnspec   from string(%string(255) s, %integer from, to)
%permstring(255)%fnspec   trim(%string(255) s, %integer max)
%externalstring(8)%fnspec time
%externalstring(9)%fnspec date
%externalintegerfnspec    cpu time
%externalstring(255)%fnspec cli param
%externalintegerfnspec    freestore {mainly just imp15}
%externalstring(255)%fnspec itos(%integer i,pos)
%externalintegerfnspec     stoi(%string(255) s)


%record %format event fm(%integer event, %integer subevent, %integer extra, %string(255) message)

! Note the ambiguity between the event field when exported as an integer
! and the event (eventfm) record containing these three fields (and more)
! as per more recent versions of Imp77.  Not quite sure yet how translated
! imp programs are going to handle that - a command-line option may be needed

! Meanwhile, to access the standard 'event' fn, redeclare it locally within the
! scope which uses it, as %externalintegerfnspec event %alias "_imp_eventno"

! by default, 'event' is:
%external %record (event fm) %fn %spec event

%permintegerfnspec        eventno
%permintegerfnspec        subevent
%permintegerfnspec        eventinfo


! Signal event codes
%constinteger PROGRAM STOP = 0
%constinteger OVERFLOW = 1
%constinteger STORE EXCEEDED = 2
%constinteger CONVERSION ERROR = 4
%constinteger ARGUMENT ERROR = 5
%constinteger RANGE ERROR = 6
%constinteger STRING RESOLUTION FAILS = 7
%constinteger UNDEFINED VALUE = 8
%constinteger INPUT ENDED = 9
%constinteger IO ERROR = 10
%constinteger JUMP OUT = 11
%constinteger USER EVENT = 12

%list { resume outputing generated C code }
%control 0

%endofperm
