%constant %integer                      nl=10
!%constant %integer                 	eof=-1
%const    %record(*)          %name 	nil == 0
%constant %integer                      File Sep = '='
%const %integer                         cMaxSigFigs = 15

{ PRIMS must NOT be changed in order...                                }
{ PRIMS are internal MACRO's within the pass2 phase of the compiler    }
{ NB Warning! only 14 %prim functions/routines are allowed at present! }
%prim     %integer        %fn   %spec   rem( %integer p,q )
%prim     %real           %fn   %spec   float( %integer n )
%prim     %string(1)      %fn   %spec   tostring( %integer c )
%prim     %integer        %fn   %spec   addr( %name p )
%prim     %integer        %map  %spec   integer( %integer n )
%prim     %byte %integer  %map  %spec   byteinteger( %integer n )
%prim     %string(*)      %map  %spec   string( %integer n )
%prim     %record(*)      %map  %spec   record( %integer n )
%prim     %real           %map  %spec   real( %integer n )
%prim     %long %real     %map  %spec   longreal( %integer n )
%prim     %byte %integer  %map  %spec   length( %string(255) s )
%prim     %byte %integer  %map  %spec   charno( %string(255) s,%integer n )
%prim     %integer        %fn   %spec   int( %longreal r )
%prim     %short %integer %map  %spec   shortinteger( %integer n )

{ Remaining routines are included within the IMP RTL }
%external %integer        %fn   %spec   type of( %name n )
%external %integer        %fn   %spec   size of( %name n )

{ Routine to map result of "typeof" function to a string }
%external %string(255)    %fn   %spec   typeName( %integer t )

{ These next 5 functions only work on those %name parameters which reference }
{ an array's (Dope Vector Pointer,Array Data Address)                        }
%external %integer        %fn   %spec   array entry size( %name n )
%external %integer        %fn   %spec   array entry type( %name n )
%external %integer        %fn   %spec   array dimensions( %name n )
%external %integer        %fn   %spec   array lower bound( %name n, %integer index )
%external %integer        %fn   %spec   array upper bound( %name n, %integer index )

{ Event handler routines }
%recordformat event fm(%integer event,sub,info, line, %string(255) message)
%external %record(event fm) %map %spec event

{ Starting point for Seek Input, Seek Output random access routines }
%const    %integer                      from start   = 0
%const    %integer                      from current = 1
%const    %integer                      from end     = 2

{ General I/O routines (implemented in C) }
{ File I/O routines                       }
{ Input routines                          }
%external %integer       %fn    %spec   Input Stream
%external %string(255)   %fn    %spec   Input Name
%external %routine              %spec   Select Input( %integer  n )
%external %routine              %spec   Open Input( %integer  n, %string(255) fd )
%external %routine              %spec   Open Binary Input( %integer  n, %string(255) fd )
%external %routine              %spec   Close Input
%external %routine              %spec   Reset Input
%external %routine              %spec   Seek Input( %integer displacement, %integer start point)
%external %integer       %fn    %spec   Tell Input
!%external %routine              %spec   Read Symbol( %integer %name p )
%external %routine              %spec   Read Symbol( %name p )
%external %integer       %fn    %spec   Next Symbol
%external %integer       %fn    %spec   Read Buffer( %name ptr, %integer count )
%external %routine              %spec   Prompt( %string(31) S )
%external %string(31)    %fn    %spec   Current Prompt
%external %integer       %fn    %spec   Get Max Input Stream
%external %predicate            %spec   File End

{ Special input routines (only intended for use by pass2 of the compiler) }
{ These allow the "end of input" event to be switched on/off              }
%external %routine              %spec   allow eof event
%external %routine              %spec   block eof event

{ Output routines }
%external %integer       %fn    %spec   Output Stream
%external %string(255)   %fn    %spec   Output Name
%external %routine              %spec   Select Output( %integer  n )
%external %routine              %spec   Open Output( %integer  n,%string(255) fd )
%external %routine              %spec   Open Binary Output( %integer  n,%string(255) fd )
%external %routine              %spec   Close Output
%external %routine              %spec   Reset Output
%external %routine              %spec   Seek Output( %integer displacement, %integer start point)
%external %integer       %fn    %spec   Tell Output
%external %routine              %spec   Print Symbol( %integer sym )
%external %integer      %fn     %spec   Write Buffer( %name ptr, %integer count )
%external %routine              %spec   Debug Symbol( %integer sym )
%external %routine              %spec   Debug Real( %longreal d )
%external %integer       %fn    %spec   Get Max Output Stream
%external %routine              %spec   Flush Output

{ Core routines implemented in IMP }
%external %routine              %spec   Skip Symbol
%external %routine              %spec   print string( %string(255)  s )
%external %routine              %spec   debug string( %string(255)  s )
%external %routine              %spec   debug newline
%external %routine              %spec   debug space
%external %routine              %spec   debug spaces( %integer count)
%external %routine              %spec   write( %integer  v,p )
%external %routine              %spec   space
%external %routine              %spec   spaces( %integer  n )
%external %routine              %spec   newline
%external %routine              %spec   newlines( %integer n )
%external %routine              %spec   print fl( %longreal f, %integer dp )
%external %routine              %spec   print real( %longreal f, %integer sf, places )
%external %routine              %spec   print float( %longreal f, %integer sf )

%external %integer       %fn    %spec   int pt( %longreal r )
%external %routine              %spec   to upper( %string(*)%name s )
%external %routine              %spec   to lower( %string(*)%name s )
%external %string(255)   %fn    %spec   I to S( %integer n, places )
%external %string(255)   %fn    %spec   F to S( %longreal f, %integer sf, places )
%external %string(255)   %fn    %spec   F to SP( %longreal f, %integer places)
%external %routine              %spec   read( %name ptr )
%external %string(255)   %fn    %spec   sub string( %string(255) s, %integer from, to )
%external %string(255)   %fn    %spec   trim( %string(255) s, %integer max )

! Debug definitions
%external %routine              %spec   Set Debug
%external %routine              %spec   Clear Debug
%external %integer       %fn    %spec   Debug Mode
%external %predicate            %spec   Show Debug

%const    %integer                      DBGMAIN = 2
%const    %integer                      DBGPROG = 4
%const    %integer                      DBGCORE = 8
%external %routine              %spec   Set Debug Level( %integer lvl )

{ multi-number base version of I to S (number base in range 2..36) }
%external %string(255)   %fn    %spec	int2ascii( %integer nn, base, places )

{ Enhanced version of int2ascii which indicates number base before the number }
%external %string(255)   %fn    %spec	formatNumber( %integer n,base,places)

{ Convert number to a hex/bin string (no sign prefix) }
%external %string(255)   %fn    %spec	int2hex( %integer nn, places )
%external %string(32)    %fn    %spec	int2bin( %integer nn )
%external %string(16)    %fn    %spec	short2bin( %shortinteger nn )

{ Experimental library routines in IMP (calling external C routines) }

{ Routines to access the environment variables (implemented in IMP) }
%external %integer       %fn    %spec   getenvcount
%external %string(255)   %fn    %spec   getenvname( %integer index )
%external %string(255)   %fn    %spec   getenv( %integer index )
%external %integer       %fn    %spec   getenvindex( %string(255) varname )
%external %string(255)   %fn    %spec   get env as string( %string(255) envname )
%external %integer       %fn    %spec   getenvasinteger( %string(255) varname )

{ Routines to access the command line parameters (implemented in IMP) }
{ NB getarg(0) == prog name                                           }
{    getarg(i) == i'th parameter                                      }
{    last command line parameter has index = getargcout - 1           }
%external %integer       %fn    %spec   getargcount
%external %string(255)   %fn    %spec   getarg( %integer index )
%external %string(255)   %fn    %spec   CLI PARAM %alias "_imp_cliparam"

{ nil needed for heap routine record manipulation and comparison     }
%external %record(*)     %map   %spec   new( %name template )
%external %routine              %spec   dispose( %name template )

{ Example routines to provide limited mathematical functions/values }
%external %long %real    %fn    %spec   sqrt(%longreal x )
%external %long %real    %fn    %spec   PI
%external %long %real    %fn    %spec   sine( %longreal x )
%external %long %real    %fn    %spec   cosine( %longreal x )
%external %long %real    %fn    %spec   Log2(%longreal x )
%external %long %real    %fn    %spec   Log( %longreal x )
%external %long %real    %fn    %spec   Log10(%longreal x )

{ Additional C utility routines to exit program }
%external %routine              %spec   exit( %integer status )

%endofperm
