#ifndef _STRINGPOOL_H_
#define _STRINGPOOL_H_ 1

typedef int StrpoolIDX;
// An index into the string pool which can be used in place of a wchar * where appropriate.

#ifdef USE_WIDE_CHARS
#define pooltowstr(S) pooltowstr_inner(S, __FILE__, __LINE__)
#define pooltostr(S)  pooltostr_inner(S, __FILE__, __LINE__)
#define STR "%ls"
extern OUR_CHAR *pooltowstr_inner(StrpoolIDX p, const char *file, const int line);
#else
#define OUR_CHAR char
#define pooltowstr(S) pooltostr_inner(S, __FILE__, __LINE__)
#define pooltostr(S)  pooltostr_inner(S, __FILE__, __LINE__)
extern char *pooltostr_inner(StrpoolIDX p, const char *file, const int line);
#define wcscmp(a,b) strcmp(a,b)
#define STR "%s"
#endif

//DECLARE(Stringpool, OUR_CHAR, 256000000 );
#define _Stringpool(x) WRITE(x,Stringpool,OUR_CHAR)
#define  Stringpool(x) READ(x,Stringpool,OUR_CHAR)

StrpoolIDX wstrtopool(const OUR_CHAR *wstr);
StrpoolIDX strtopool(const char *str);
StrpoolIDX StrToPool(const char *s);

OUR_CHAR *pooltowstr_inner(StrpoolIDX p, const char *file, const int line);
char *pooltostr_inner(StrpoolIDX p, const char *file, const int line);

#endif
