#ifndef _SYMTAB_PRIV_H_
#define _SYMTAB_PRIV_H_ 1

// This library provides support routines for handling scoped symbol tables.

// Implementation:
//    We use an unordered linked list in this implementation, however the interface
// does not care what the internal implementation is - the external interface is neutral
// in that respect.  We'll use the 'dumb' linked list implementation as long as the
// runtime overhead remains insignificant, at which point the implementation side of
// this library can be rewritten - perhaps with a trie, or by sorting the list elements
// into a flex array, or even using a traditional but space-wasting hash table.

typedef struct generic_table_entry generic_table_entry;
typedef struct generic_table_entry {
  OUR_CHAR *entry_name;
  DATA entry_data;
  generic_table_entry *next_entry;
} generic_table_entry;

typedef struct table_list table_list;
typedef struct table_list {
  char *table_name;
  generic_table_entry *table_data;
  table_list *next_table;
} table_list;

typedef struct scope_list scope_list;
typedef struct scope_list {
  int level;
  table_list *table;
  scope_list *next_scope;
} scope_list;

extern scope_list *top_level_scope;
extern scope_list *base_level_scope;
#endif
