#include <stdio.h>
static int trace_depth = 0;

void imp_trace_enter(int line, char *file, char *funcname) {
  for (int i = trace_depth; i > 0; i--) fputc(' ', stderr);
  fprintf(stderr, "\"%s\", %d: > %s\n", file, line, funcname);
  trace_depth += 1;
}

void imp_trace_exit(int line, char *file, const char *funcname) {
  trace_depth -= 1;
  for (int i = trace_depth; i > 0; i--) fputc(' ', stderr);
  fprintf(stderr, "\"%s\", %d: < %s\n", file, line, funcname);
}

