/*
 * File: opcode.h
 *
 * ICL 2900 IMP80 compiler
 *
 * Register and instruction symbol definitions
 *
 * Copyright (c) 2026, Bob Eager
 *
 */

#ifndef	_OPCODE_H
#define	_OPCODE_H	0

#include "typedefs.h"

/* Principal opcodes */

/* Primary */

#define	VAL		0x10
#define	CYD		0x12
#define	INCA		0x14
#define	MODD		0x16
#define	PRCL		0x18
#define	JUNC		0x1a
#define	JLK		0x1c
#define	CALL		0x1e
#define	ADB		0x20
#define	SBB		0x22
#define	DEBJ		0x24
#define	CPB		0x26
#define	SIG		0x28
#define	MYB		0x2a
#define	VMY		0x2c
#define	CPIB		0x2e
#define	LCT		0x30
#define	MPSR		0x32
#define	CPSR		0x34
#define	STCT		0x36
#define	EXIT		0x38
#define	ESEX		0x3a
#define	OUT		0x3c
#define	ACT		0x3e
#define	SL		0x40
#define	SLSS		0x42
#define	SLSD		0x44
#define	SLSQ		0x46
#define	ST		0x48
#define	STUH		0x4a
#define	STXN		0x4c
#define	IDLE		0x4e
#define	SLD		0x50
#define	SLB		0x52
#define	TDEC		0x54
#define	INCT		0x56
#define	STD		0x58
#define	STB		0x5a
#define	STLN		0x5c
#define	STSF		0x5e
#define	L		0x60
#define	LSS		0x62
#define	LSD		0x64
#define	LSQ		0x66
#define	RRTC		0x68
#define	LUH		0x6a
#define	RALN		0x6c
#define	ASF		0x6e
#define	LDRL		0x70
#define	LDA		0x72
#define	LDTB		0x74
#define	LDB		0x76
#define	LD		0x78
#define	LB		0x7a
#define	LLN		0x7c
#define	LXN		0x7e
#define	EXPA		0x88
#define	AND		0x8a
#define	OR		0x8c
#define	NEQ		0x8e
#define	COMA		0x98
#define	DDV		0x9a
#define	DRDV		0x9c
#define	DMDV		0x9e
#define	FLT		0xa8
#define	IDV		0xaa
#define	IRDV		0xac
#define	IMDV		0xae
#define	FIX		0xb8
#define	RDV		0xba
#define	RRDV		0xbc
#define	RDVD		0xbe
#define	UAD		0xc0
#define	USB		0xc2
#define	URSB		0xc4
#define	UCP		0xc6
#define	USH		0xc8
#define	ROT		0xca
#define	SHS		0xcc
#define	SHZ		0xce
#define	DAD		0xd0
#define	DSB		0xd2
#define	DRSB		0xd4
#define	DCP		0xd6
#define	DSH		0xd8
#define	DMY		0xda
#define	DMYD		0xdc
#define	CBIN		0xde
#define	IAD		0xe0
#define	ISB		0xe2
#define	IRSB		0xe4
#define	ICP		0xe6
#define	ISH		0xe8
#define	IMY		0xea
#define	IMYD		0xec
#define	CDEC		0xee
#define	RAD		0xf0
#define	RSB		0xf2
#define	RRSB		0xf4
#define	RCP		0xf6
#define	RSC		0xf8
#define	RMY		0xfa
#define	RMYD		0xfc

/* Secondary */

#define	TCH		0x80
#define	ANDS		0x82
#define	ORS		0x84
#define	NEQS		0x86
#define	PK		0x90
#define	INS		0x92
#define	SUPK		0x94
#define	SWEQ		0xa0
#define	SWNE		0xa2
#define	CPS		0xa4
#define	TTR		0xa6
#define	MVL		0xb0
#define	MV		0xb2
#define	MVL		0xb0
#define	MV		0xb2
#define	CHOV		0xb4

/* Tertiary */

#define	JCC		0x02
#define	JAT		0x04
#define	JAF		0x06

/* Registers etc. The values 2-7 correspond to the k'' values in primary
   format operands, and must not be changed. These values are also used
   as indices into the register use arrays. */

#define	ACCR		0
#define	DR		1
#define	LNB		2
#define	XNB		3
#define	PC		4
#define	CTB		5
#define	TOS		6
#define	BREG		7

#endif

/*
 * End of file: opcode.h
 *
 */
