{ Formats for shared memory }


{ Monitor block }

%constinteger last stat = 8
%recordformat monitor fm((%integer file reads,
                          %integer file writes,
                          %integer ether reads,
                          %integer ether writes,
                          %integer ether errors,
                          %integer OK ops,
                          %integer error ops,
                          %integer logons) %c
                     %or %integerarray s(1 : last stat))


{ Trace buffer }

%recordformat trace fm(%integer context, inout,
                       %string(55) text)
%recordformat trace buffer fm(%integer p,
                              %record(trace fm)%array t(0 : tbuffs))
%constinteger trace in  = 0
%constinteger trace out = 1


{ Timestamp record }

%recordformat stamp fm(%short date, time)


{ Ether information }

%recordformat port fm(%integer remote, port, state, retries, lives,
                      %record(stamp fm) opened stamp, active stamp)
{ <remote> is address of client talking to port
{ <port> is the port which the client is using
{ <state> gives info on the port's current activity
{ <lives> counts down to port timeout
{ <opened stamp> indicates when the port was opened
{ <active stamp> indicates when outgoing data was last written

%recordformat ether buffer fm(%integer context,
                              %integer bytes,
                              %integer sequence count,
                              %bytearray data(0 : 539))
{ <context>  >= 0 for port number -- forward to a user process
{            <  0 for non-standard processing by ether process
{ <bytes> indicates how much of <data> has been used
{ <sequence count> indicates how many times to repeat operation

%recordformat ether buffer area fm(%integer next to use,
                                   %integer next to process,
                                   %record(ether buffer fm)%array %c
                                                buffer(0 : ether buffers))
{ <next to use> gives next buffer to be written by ether RX
{ <next to process> gives next buffer to be processed by ether process


{ Data buffer }

%recordformat buffer fm(%integer context,
                        %integer ether packet,
                        %integer sequence,
                        %integer sequence Xno,
                        %integer sequence count,
                        %integer error,
                        %integer bytes,
                        %string(255) text,
                        %bytearray b(0 : 511))
{ <data> and <context> are used for queuing a process request packet
{ <bytes> indicates how much of <b> to send
{ <text> contains filestore command/response text
{ <link> chains buffer on a request queue or the free list
{ <error> contains 0 (for success) or a filestore error number
{ <b> contains the data to be read/written
{ <context> is ether context of request
{ <ether packet> is buffer number of incoming request


{ Uno and Xno information blocks }

%recordformat Uno info fm(%string(31)                 l user,
                          %string(255)                l directory,
                          %string(255)                d directory,
                          %string(255)                F directory,
                          %string(255)                F es,
                          %string(255)                F rs,
                          %integer                    F position,
                          %integer                    context,
                          %record(stamp fm)           logon stamp,
                          %record(stamp fm)           active stamp,
                          %record(stamp fm)           Xno active stamp,
                          %record(fab fm)             f,
                          %record(nam fm)             n,
                          %record(xabpro fm)          xp,
                          %record(xabdat fm)          xd,
                          %record(xabfhc fm)          xf,
                          %integer                    UIC,
                          %record(quad fm)            privileges)
{ <l user> is username of logged-on user
{ <l directory> is default directory for logged-on owner
{ <d directory> is current default directory
{ <context> is ether context for which Uno is valid
{ <logon stamp> indicates when user logged on
{ <active stamp> indicates when Uno was last used
{ <Xno active stamp> indicates when an Xno belonging to the Uno was used
{ <f>, <n>, <xp>, <xd>, <xf> are RMS control blocks
{ <UIC> and <privileges> are those of the logged-on user


%recordformat Xno info fm(%integer                    Uno,
                          %integer                    context,
                          %integer                    mode,
                          %integer                    flags,
                          %integer                    remaining,
                          %integer                    total blocks,
                          %integer                    last byte,
                          %integer                    blocks,
                          %integer                    last block moved,
                          %record(stamp fm)           opened stamp,
                          %record(stamp fm)           active stamp,
                          %string(255)                filename,
                          %record(fab fm)             f,
                          %record(rab fm)             r,
                          %record(nam fm)             n,
                          %record(xabfhc fm)          xf,
                          %integer                    next rb,
                          %bytearray                  rbuff(1 : 512))
{ <Uno> is user corresponding to this Xno
{ <context> is ether context for which Xno is valid
{ <mode> indicates how file was opened
{ <flags> gives status of transaction
{ <remaining> is count of blocks still to read
{ <last byte> is position of last byte in last block
{ <blocks> counts size of file as it is written
{ <last block moved> is to expedite sequential DA reads & writes
{ <opened stamp> indicates when transaction was opened
{ <active stamp> indicates when Xno was last used
{ <filename> is fully parsed name of file
{ <f>, <r>, <n>, <xf> are RMS control blocks for file
{ <rbuff> is a record buffer for use with non-block-readable files
{ <next rb> indicates which byte to take next

%constinteger Xno last block  = 1
%constinteger no block read   = 2


{ Common area format }

%recordformat common fm(%integer                      ether request queue,
                        %record(monitor fm)           monitor,
                        %record(ether buffer area fm) ether buffer,
                        %record(port fm)%array        port info(1 : ports),
                        %record(buffer fm)            buffer,
                        %record(Uno info fm)%array    Uno     (0 : Unos),
                        %record(Xno info fm)%array    Xno     (1 : Xnos),
                        %record(trace buffer fm)      trace,
                        %integer                      end)

%constinteger ether diags = 1
%constinteger proc  diags = 2
%constinteger fsys  diags = 4

%end %of %file
