{ Formats for file system QIO interface... }      %end %of %list

{ This version intended to avoid dictionary overflow }

%recordformat atr fm(%short size, type, %integer addr)

!constinteger  ATR C UCHAR       = 3
%constinteger  ATR C RECATTR     = 4
!constinteger  ATR C FILNAM      = 5
!constinteger  ATR C FILTYP      = 6
!constinteger  ATR C FILVER      = 7
!constinteger  ATR C EXPDAT      = 8
!constinteger  ATR C STATBLK     = 9
!constinteger  ATR C HEADER      = 10
!constinteger  ATR C BLOCKSIZE   = 11
!constinteger  ATR C USERLABEL   = 12
!constinteger  ATR C ASCDATES    = 13
!constinteger  ATR C ALCONTROL   = 14
!constinteger  ATR C ENDLBLAST   = 15
!constinteger  ATR C ASCNAME     = 16
!constinteger  ATR C CREDATE     = 17
!constinteger  ATR C REVDATE     = 18
!constinteger  ATR C EXPDATE     = 19
!constinteger  ATR C BAKDATE     = 20
!constinteger  ATR C UIC         = 21
!constinteger  ATR C FPRO        = 22
!constinteger  ATR C RPRO        = 23
!constinteger  ATR C ACLEVEL     = 24
!constinteger  ATR C SEMASK      = 25
!constinteger  ATR C UIC RO      = 26
!constinteger  ATR C DIRSEQ      = 27
!constinteger  ATR C BACKLINK    = 28
!constinteger  ATR C JOURNAL     = 29
!constinteger  ATR C HDR1 ACC    = 30

!constinteger  ATR S UCHAR       =  4 
%constinteger  ATR S RECATTR     = 32
!constinteger  ATR S FILNAM      =  6
!constinteger  ATR S FILTYP      =  2
!constinteger  ATR S FILVER      =  2
!constinteger  ATR S EXPDAT      =  7
!constinteger  ATR S STATBLK     = 32
!constinteger  ATR S HEADER      = x'200'
!constinteger  ATR S BLOCKSIZE   =  2
!constinteger  ATR S USERLABEL   = 80
!constinteger  ATR S ASCDATES    = 35
!constinteger  ATR S ALCONTROL   = 14
!constinteger  ATR S ENDLBLAST   =  4
!constinteger  ATR S ASCNAME     = 20
!constinteger  ATR S CREDATE     =  8
!constinteger  ATR S REVDATE     =  8
!constinteger  ATR S EXPDATE     =  8
!constinteger  ATR S BAKDATE     =  8
!constinteger  ATR S UIC         =  4 
!constinteger  ATR S FPRO        =  2 
!constinteger  ATR S RPRO        =  2
!constinteger  ATR S ACLEVEL     =  1
!constinteger  ATR S SEMASK      =  8
!constinteger  ATR S UIC RO      =  4
!constinteger  ATR S DIRSEQ      =  2
!constinteger  ATR S BACKLINK    =  6
!constinteger  ATR S JOURNAL     =  2
!constinteger  ATR S HDR1 ACC    =  1


%recordformat fat fm(%byte       rtype,
                     %byte       rattrib,
                     %short      rsize,
                     (%integer   hiblk %or %c
                      (%short    hiblkh,
                       %short    hiblkl)),
                     (%integer   efblk %or %c
                      (%short    efblkh,
                       %short    efblkl)),
                     %short      ffbyte,
                     %byte       bktsize,
                     %byte       vfcsize,
                     %short      maxrec,
                     %short      defext,
                     %short      gbc,
                     %short      spare1, spare2, spare3, spare4,
                     %short      versions)

!constinteger  FAT V RTYPE       =  0
!constinteger  FAT S RTYPE       =  4
!constinteger  FAT V FILEORG     =  4
!constinteger  FAT S FILEORG     =  4
!constinteger  FAT C UNDEFINED   =  0
!constinteger  FAT C FIXED       =  1
!constinteger  FAT C VARIABLE    =  2
!constinteger  FAT C VFC         =  3
!constinteger  FAT C STREAM      =  4
!constinteger  FAT C STREAMLF    =  5
!constinteger  FAT C STREAMCR    =  6
!constinteger  FAT C SEQUENTIAL  =  0
!constinteger  FAT C RELATIVE    =  1
!constinteger  FAT C INDEXED     =  2
!constinteger  FAT C DIRECT      =  3
!constinteger  FAT V FORTRANCC   =  0
!constinteger  FAT M FORTRANCC   =  1
!constinteger  FAT V IMPLIEDCC   =  1
!constinteger  FAT M IMPLIEDCC   =  2
!constinteger  FAT V PRINTCC     =  2
!constinteger  FAT M PRINTCC     =  4
!constinteger  FAT V NOSPAN      =  3
!constinteger  FAT M NOSPAN      =  8


%recordformat fib fm((%integer   acctl %or %c
                      (%byte     a1, a2, a3,
                       %byte     wsize)),
                     %record(fid fm) fid,
                     %record(fid fm) did,
                     %integer    wcc,
                     %short      nmctl,
                     %short      exctl,
                     %integer    exsz,
                     %integer    exvbn,
                     %byte       alopts,
                     %byte       alalign,
                     %record(fid fm) loc fid,
                     %integer    loc addr,
                     %short      verlimit,
                     %short      cntrlfunc,
                     %integer    cntrlval)
%constinteger fib size = 44

!constinteger   FIB M NOWRITE    = 1
!constinteger   FIB M DLOCK      = 2
!constinteger   FIB M BLK LOCK   = 4
!constinteger   FIB M SPOOL      = 16
!constinteger   FIB M WRITECK    = 32
!constinteger   FIB M SEQONLY    = 64
!constinteger   FIB M WRITE      = 256
!constinteger   FIB M READCK     = x'200'
!constinteger   FIB M NOREAD     = x'400'
!constinteger   FIB M NOTRUNC    = x'800'
!constinteger   FIB M EXECUTE    = x'10000'
!constinteger   FIB M PRSRV ATR  = x'20000'
!constinteger   FIB M RMSLOCK    = x'40000'
!constinteger   FIB M WRITETHRU  = x'80000'
!constinteger   FIB M NOLOCK     = x'100000'
!constinteger   FIB M NORECORD   = x'200000'

!constinteger   FIB M REWIND     = 8
!constinteger   FIB M CURPOS     = 16
!constinteger   FIB M UPDATE     = 64
!constinteger   FIB M ALLVER     = 8
!constinteger   FIB M ALLTYP     = 16
!constinteger   FIB M ALLNAM     = 32
!constinteger   FIB M WILD       = 256
!constinteger   FIB M NEWVER     = x'200'
!constinteger   FIB M SUPERSEDE  = x'400'
!constinteger   FIB M FINDFID    = x'800'
!constinteger   FIB M LOWVER     = x'4000'
!constinteger   FIB M HIGHVER    = x'8000'

!constinteger   FIB M ALCON      = 1
!constinteger   FIB M ALCONB     = 2
!constinteger   FIB M FILCON     = 4
!constinteger   FIB M ALDEF      = 8
!constinteger   FIB M ALLOCATR   = 16
!constinteger   FIB M EXTEND     = 128
!constinteger   FIB M TRUNC      = 256
!constinteger   FIB M NOHDREXT   = x'200'
!constinteger   FIB M MARKBAD    = x'400'
!constinteger   FIB M NOCHARGE   = x'8000'

!constinteger   FIB M EXACT      = 1
!constinteger   FIB M ONCYL      = 2

!constinteger   FIB C CYL        = 1
!constinteger   FIB C LBN        = 2
!constinteger   FIB C VBN        = 3
!constinteger   FIB C RFI        = 4

!constinteger   FIB C REWINDVOL  = 1
!constinteger   FIB C POSEND     = 2
!constinteger   FIB C NEXTVOL    = 3
!constinteger   FIB C SPACE      = 4
!constinteger   FIB C ILLEGAL    = 5
!constinteger   FIB C REWINDFIL  = 6
!constinteger   FIB C LOCK VOL   = 7
!constinteger   FIB C UNLK VOL   = 8
!constinteger   FIB C ENA QUOTA  = 9
!constinteger   FIB C DSA QUOTA  = 10
!constinteger   FIB C ADD QUOTA  = 11
!constinteger   FIB C EXA QUOTA  = 12
!constinteger   FIB C MOD QUOTA  = 13
!constinteger   FIB C REM QUOTA  = 14
!constinteger   FIB C USEREOT    = 15
!constinteger   FIB C REMAP      = 16

!constinteger   FIB M ALL MEM    = 1
!constinteger   FIB M ALL GRP    = 2
!constinteger   FIB M MOD USE    = 4
!constinteger   FIB M MOD PERM   = 8
!constinteger   FIB M MOD OVER   = 16

%end %of %file
