! TCP TCB format & constants

%constinteger max TCB table = 256;  ! Upper bound only
%ownstring(31) TCB table name = "INET__TCB_TABLE"

%constinteger time wait timeout = 12000;  ! msecs

%constinteger TCP initial receive window  = 2048
%constinteger TCP unspecified mrss        = 1023;  ! For compatibility
%constinteger TCP default mrss            = 1023

%recordformat TCB fm(%integer remote address, remote port, local port,
                     %integer slot,
                     %record(peer info fm)%name peer info,
                     %integer ISS, IRS, FIN seq,
                     %integer snd una, snd nxt, snd up,
                     %integer snd wnd, snd wl1, snd wl2,
                     %integer rcv nxt, rcv wnd, rcv up,
                     %integer state, previous state, state change stamp,
                     %integer ack pending, blocked send,
                     %record(queue header fm) blocked send queue,
                     %record(queue header fm) retransmit queue,
                     %record(queue header fm) Xpending retransmit queue,
                     %record(queue header fm) reordering queue,
                     %record(queue header fm) state change queue,
                     %integer retransmit timer, retransmit timeout,
                     %integer round trip timer,
                     %integer mrss, mtss)
! retransmit timer    contains stamp when packet was sent
! retransmit timeout  contains offset for when retransmission is required
%constinteger TCB size = 12 + 4 + 4 + 12 + 24 + 12 + 12 + 8 + 40 + 8 + 4 + 8

%recordformat TCB table fm(%record(TCB fm)%array TCB(1 : max TCB table))
%ownrecord(TCB table fm)%name TCB table == 0

! TCP states (**NB order important**)
%constinteger TCP closed         = 0
%constinteger TCP listen         = 1
%constinteger TCP syn sent       = 2
%constinteger TCP syn received   = 3
%constinteger TCP established    = 4
%constinteger TCP fin wait 1     = 5
%constinteger TCP fin wait 2     = 6
%constinteger TCP close wait     = 7
! States from here on are ignored for (implied) ABORT requests
%constinteger TCP closing        = 8
%constinteger TCP last ack       = 9
%constinteger TCP time wait      = 10

%conststring(15)%array TCP state name(TCP closed : TCP time wait) =
   "closed",
   "listen",
   "syn sent",
   "syn received",
   "established",
   "fin wait 1",
   "fin wait 2",
   "close wait",
   "closing",
   "last ack",
   "time wait"

%constinteger RTT a = 800, RTT a denominator = 1000
%constinteger RTT b = 130, RTT b denominator = 100

%constinteger TCP initial RTT =  150;  ! msecs

%constinteger TCP reTX lbound =  100;  ! msecs
%constinteger TCP reTX ubound = 1500;  ! msecs

%end %of %file
