PROC ss.scrstream.to.ANSI.bytes (CHAN OF SS scrn, CHAN OF BYTE ansi)

  --{{{  specification
  -- Purpose:  To convert output in screen stream protocol to
  --           output of a byte stream using ANSI screen conventions.
  -- Channels: ansi - for output
  --           scrn - for input
  -- Notes:    Receipt of st.endstream will terminate this procedure.
  --}}}
  --{{{  history
  -- Included st.help and st.initialise in the CASE input.
  -- New version is 1.2; 15-June-90 SRH
  --}}}

  #USE "convert.lib"
  --{{{  INTWRITE
  PROC INTWRITE (CHAN OF BYTE out, VAL INT v)
    --  Beta-2 (27feb87)
    [40]BYTE string :
    INT len :
    SEQ
      INTTOSTRING (len, string, v)
      SEQ i = 0 FOR len
	out ! string [i]
  :
  --}}}

  VAL esc IS 27(BYTE):
  VAL bell IS 7(BYTE):
  VAL bs IS 8(BYTE):

  BOOL going:
  SEQ
    --{{{  main body
    going := TRUE
    WHILE going
      SEQ
	scrn ? CASE
	  --{{{  ST.OUT.STRING
	  [st.max.string.size]BYTE str:
	  INT32 len:
	  st.out.string; len::str
	    SEQ i = 0 FOR INT len
	      ansi ! str[i]
	  --}}}
	  --{{{  ST.CHAR
	  BYTE st.char :
	  st.out.byte; st.char
	    ansi ! st.char
	  --}}}
	  --{{{  ST.INS.CHAR
	  BYTE st.char :
	  st.ins.char; st.char
	    SKIP
	  --}}}
	  --{{{  ST.OUT.INT
	  INT32 x :
	  st.out.int; x
	    ansi ! BYTE x
	  --}}}
	  --{{{  ST.GOTO
	  INT32 x,y:
	  st.goto; x; y
	    SEQ
	      ansi ! esc
	      ansi ! '['
	      INTWRITE (ansi, (INT y) + 1)
	      ansi ! ';'
	      INTWRITE (ansi, (INT x) + 1)
	      ansi ! 'H'
	  --}}}
	  --{{{  ST.RESET
	  st.reset
	    SKIP
	  --}}}
	  --{{{  ST.UP
	  st.up
	    SEQ
	      ansi ! esc
	      ansi ! '['
	      ansi ! 'A'
	  --}}}
	  --{{{  ST.DOWN
	  st.down
	    SEQ
	      ansi ! esc
	      ansi ! '['
	      ansi ! 'B'
	  --}}}
	  --{{{  ST.LEFT
	  st.left
	    SEQ
	      ansi ! esc
	      ansi ! '['
	      ansi ! 'D'
	  --}}}
	  --{{{  ST.RIGHT
	  st.right
	    SEQ
	      ansi ! esc
	      ansi ! '['
	      ansi ! 'C'
	  --}}}
	  --{{{  ST.DEL.CHAR
	  st.del.char
	    SEQ
	      ansi ! bs
	      ansi ! ' '
	      ansi ! bs
	  --}}}
	  --{{{  ST.CLEAR.EOL
	  st.clear.eol
	    SEQ
	      ansi ! esc
	      ansi ! '['
	      ansi ! 'K'
	  --}}}
	  --{{{  ST.CLEAR.EOS
	  st.clear.eos
	    SEQ
	      ansi ! esc
	      ansi ! '['
	      ansi ! 'J'
	  --}}}
	  --{{{  ST.INS.LINE
	  st.ins.line
	    SEQ
	      ansi ! esc
	      ansi ! '['
	      ansi ! 'L'
	  --}}}
	  --{{{  ST.DEL.LINE
	  st.del.line
	    SEQ
	      ansi ! esc
	      ansi ! '['
	      ansi ! 'M'
	  --}}}
	  --{{{  ST.BEEP
	  st.beep
	    ansi ! bell
	  --}}}
	  --{{{  ST.TERMINATE
	  st.terminate
	    SKIP
	  --}}}
	  --{{{  ST.HELP
	  st.help
	    SKIP
	  --}}}
	  --{{{  ST.INITIALISE
	  st.initialise
	    SKIP
	  --}}}
	  --{{{  ST.KEY.RAW
	  st.key.raw
	    SKIP
	  --}}}
	  --{{{  ST.KEY.COOKED
	  st.key.cooked
	    SKIP
	  --}}}
	  --{{{  ST.RELEASE
	  st.release
	    SKIP
	  --}}}
	  --{{{  ST.CLAIM
	  st.claim
	    SKIP
	  --}}}
	  --{{{  ST.ENDSTREAM
	  st.endstream
	    going := FALSE
	  --}}}
	  -- if sp.spare is received then something is wrong => STOP
    --}}}
:
