PROC ss.scrstream.to.TVI920.bytes (CHAN OF SS scrn, CHAN OF BYTE tvi)

  --{{{  specification
  -- Purpose:  To convert output in screen stream protocol to
  --           output as a byte stream using TVI920 screen conventions.
  -- Channels: tvi - for output
  --           scrn - for input
  -- Notes:    Receipt of st.endstream will terminate this procedure.
  --}}}
  --{{{  history
  -- Included st.help and st.initialise in the CASE input.
  -- New version is 1.2; 15-June-90 SRH
  --}}}

  VAL esc  IS 27(BYTE):
  VAL bell IS  7(BYTE):
  VAL bs   IS  8(BYTE):
  VAL ff   IS 12(BYTE):
  VAL vt   IS 11(BYTE):
  VAL lf   IS 10(BYTE):

  BOOL going:
  SEQ
    --{{{  main body
    going := TRUE
    WHILE going
      SEQ
	scrn ? CASE
	  --{{{  st.out.string
	  [st.max.string.size]BYTE str:
	  INT32 len:
	  st.out.string; len::str
	    SEQ i = 0 FOR INT len
	      tvi ! str[i]
	  --}}}
	  --{{{  st.out.char
	  BYTE st.char :
	  st.out.byte; st.char
	    tvi ! st.char
	  --}}}
	  --{{{  st.ins.char
	  BYTE st.char :
	  st.ins.char; st.char
	    SEQ
	      tvi ! esc
	      tvi ! 'Q'
	      tvi ! st.char
	  --}}}
	  --{{{  st.out.int
	  INT32 x :
	  st.out.int; x
	    tvi ! BYTE x
	  --}}}
	  --{{{  st.goto
	  INT32 x,y:
	  st.goto; x; y
	    SEQ
	      tvi ! esc
	      tvi ! '='
	      tvi ! BYTE((INT y) + 32)
	      tvi ! BYTE((INT x) + 32)
	  --}}}
	  --{{{  st.reset
	  st.reset
	    SKIP
	  --}}}
	  --{{{  st.up
	  st.up
	    tvi ! vt
	  --}}}
	  --{{{  st.down
	  st.down
	    tvi ! lf
	  --}}}
	  --{{{  st.left
	  st.left
	    tvi ! bs
	  --}}}
	  --{{{  st.right
	  st.right
	    tvi ! ff
	  --}}}
	  --{{{  st.del.char
	  st.del.char
	    SEQ
	      tvi ! esc
	      tvi ! 'W'
	  --}}}
	  --{{{  st.clear.eol
	  st.clear.eol
	    SEQ
	      tvi ! esc
	      tvi ! 'T'
	  --}}}
	  --{{{  st.clear.eos
	  st.clear.eos
	    SEQ
	      tvi ! esc
	      tvi ! 'Y'
	  --}}}
	  --{{{  st.ins.line
	  st.ins.line
	    SEQ
	      tvi ! esc
	      tvi ! 'E'
	  --}}}
	  --{{{  st.del.line
	  st.del.line
	    SEQ
	      tvi ! esc
	      tvi ! 'R'
	  --}}}
	  --{{{  st.beep
	  st.beep
	    tvi ! bell
	  --}}}
	  --{{{  st.terminate
	  st.terminate
	    SKIP
	  --}}}
	  --{{{  st.help
	  st.help
	    SKIP
	  --}}}
	  --{{{  st.initialise
	  st.initialise
	    SKIP
	  --}}}
	  --{{{  st.key.raw
	  st.key.raw
	    SKIP
	  --}}}
	  --{{{  st.key.cooked
	  st.key.cooked
	    SKIP
	  --}}}
	  --{{{  st.release
	  st.release
	    SKIP
	  --}}}
	  --{{{  st.claim
	  st.claim
	    SKIP
	  --}}}
	  --{{{  st.endstream
	  st.endstream
	    going := FALSE
	  --}}}
	  -- if st.spare is received then something is wrong => STOP
    --}}}
:
