/*{{{  include files */
#include <stdlib.h>
#include <string.h>

#include <misc.h>

#include <process.h>
/*}}}*/

/*{{{  iserver constants */
#define SP_MIN_PACKET_DATA_SIZE 6
#define SP_MAX_PACKET_DATA_SIZE 510

#define SP_EXIT_TAG 35

#define SPR_OK 0

#define SPS_SUCCESS 999999999
/*}}}*/

/*{{{  static procedures */
/*{{{  SpExit */
static int SpExit (Channel *HostInput, Channel *HostOutput, int Status)
{
    int Length = SP_MIN_PACKET_DATA_SIZE;
    char Buffer[SP_MIN_PACKET_DATA_SIZE];

    Buffer[0] = SP_EXIT_TAG;

    memcpy(&Buffer[1], &Status, 4); /* Store exit status */

    ChanOut(HostOutput, &Length, 2);
    ChanOut(HostOutput, Buffer, Length);

    ChanIn(HostInput, &Length, 2);
    ChanIn(HostInput, Buffer, Length);

    return(Buffer[0]);
}
/*}}}*/

/*{{{  CreateChannels */
static Channel ** CreateChannels (Channel *OldChannels[], int ChannelsSize)
{
    Channel **NewChannels = NULL;

    if ((NewChannels = malloc((ChannelsSize + 1) * sizeof(Channel *))) == NULL)
        abort();
    else
    {
        /*{{{   */
        int ChannelsCount = 0;
        
        while (ChannelsCount++ < ChannelsSize)
            NewChannels[ChannelsCount - 1] = OldChannels[ChannelsCount - 1];
        
        NewChannels[ChannelsSize] = NULL;
        /*}}}*/
    }
    return(NewChannels);
}
/*}}}*/

/*{{{  RotateChannels */
static void RotateChannels (Channel *Channels[], int ChannelsSize)
{
    int ChannelsCount = 0;
    Channel *LastChannel = NULL;

    LastChannel = Channels[ChannelsCount];

    while (ChannelsCount++ < ChannelsSize)
        Channels[ChannelsCount - 1] = Channels[ChannelsCount];

    Channels[ChannelsSize - 1] = LastChannel;
}
/*}}}*/
/*}}}*/

/*{{{  global procedures */
/*{{{  main */
int main (void)
{
    int InputSize = 0, OutputSize = 0;
    Channel **Input = NULL, **Output = NULL;
    Channel *HostInput = NULL, *HostOutput = NULL;

    set_abort_action(ABORT_HALT);

    /*{{{  input channel arrays */
    HostInput = get_param(1);
    HostOutput = get_param(2);
    
    InputSize = *((int *) get_param(4));
    Input = CreateChannels(get_param(3), InputSize);
    
    OutputSize = *((int *) get_param(6));
    Output = CreateChannels(get_param(5), OutputSize);
    /*}}}*/

    if (InputSize == OutputSize)
    {
        /*{{{   */
        int ExitCount = InputSize;
        
        while (ExitCount > 0)
        {
            /*{{{   */
            int Index = 0, Length = 0;
            char Buffer[SP_MAX_PACKET_DATA_SIZE];
            
            Index = ProcAltList(Input);
            
            ChanIn(Input[Index], &Length, 2);
            ChanIn(Input[Index], Buffer, Length);
            
            if (Buffer[0] == SP_EXIT_TAG)
            {
                /*{{{   */
                ExitCount--;
                
                Buffer[0] = SPR_OK; /* Successful exit */
                
                ChanOut(Output[Index], &Length, 2);
                ChanOut(Output[Index], Buffer, Length);
                /*}}}*/
            }
            else
            {
                /*{{{   */
                ChanOut(HostOutput, &Length, 2);
                ChanOut(HostOutput, Buffer, Length);
                
                ChanIn(HostInput, &Length, 2);
                ChanIn(HostInput, Buffer, Length);
                
                ChanOut(Output[Index], &Length, 2);
                ChanOut(Output[Index], Buffer, Length);
                /*}}}*/
            }
            
            RotateChannels(Input, InputSize);
            RotateChannels(Output, OutputSize);
            /*}}}*/
        }
        
        (void) SpExit(HostInput, HostOutput, SPS_SUCCESS);
        /*}}}*/
    }
    else
        abort();
}
/*}}}*/
/*}}}*/
