/*{{{  include files */
#include <stdio.h>
#include <stdlib.h>

#include <misc.h>
#include <process.h>
/*}}}*/

/*{{{  static variables */
static int TotalValue = 0;
/*}}}*/

/*{{{  static procedures */
/*{{{  CreateChannels */
static Channel ** CreateChannels (Channel *OldChannels[], int ChannelsSize)
{
    Channel **NewChannels = NULL;

    if ((NewChannels = malloc((ChannelsSize + 1) * sizeof(Channel *))) == NULL)
        abort();
    else
    {
        /*{{{   */
        int ChannelsCount = 0;
        
        while (ChannelsCount++ < ChannelsSize)
            NewChannels[ChannelsCount - 1] = OldChannels[ChannelsCount - 1];
        
        NewChannels[ChannelsSize] = NULL;
        /*}}}*/
    }
    return(NewChannels);
}
/*}}}*/

/*{{{  InputProcess */
static void InputProcess (Process *InputP, Channel *Input[], int InputSize)
{
    int Value = TotalValue, InputCount = 0;

    /*{{{  statement to prevent warnings */
    InputP = InputP;
    /*}}}*/

    while (InputCount++ < InputSize)
    {
        /*{{{   */
        int Index = ProcAltList(Input);
        
        Value += ChanInInt(Input[Index]);
        /*}}}*/
    }
    TotalValue = Value;
}
/*}}}*/

/*{{{  OutputProcess */
static void OutputProcess (Process *OutputP, Channel *Output[], int OutputSize)
{
    int Value = TotalValue + 1, OutputCount = 0;

    /*{{{  statement to prevent warnings */
    OutputP = OutputP;
    /*}}}*/

    while (OutputCount < OutputSize)
        ChanOutInt(Output[OutputCount++], Value);
}
/*}}}*/
/*}}}*/

/*{{{  global procedures */
/*{{{  main */
int main (void)
{
    int InputSize = 0, OutputSize = 0;
    Channel **Input = NULL, **Output = NULL;

    set_abort_action(ABORT_HALT);

    /*{{{  input channel arrays */
    InputSize = *((int *) get_param(4));
    Input = CreateChannels(get_param(3), InputSize);
    
    OutputSize = *((int *) get_param(6));
    Output = CreateChannels(get_param(5), OutputSize);
    /*}}}*/

    if (InputSize == OutputSize)
    {
        /*{{{   */
        Process *InputP = NULL;
        
        if ((InputP = ProcAlloc(InputProcess, 128, 2, Input, InputSize)) == NULL)
            abort();
        else
        {
            /*{{{   */
            Process *OutputP = NULL;
            
            if ((OutputP = ProcAlloc(OutputProcess, 128, 2, Output, OutputSize)) == NULL)
                abort();    
            else
            {
                /*{{{   */
                while (1)
                {
                    /*{{{   */
                    ProcPar(InputP, OutputP, NULL);
                    
                    printf("%d\n", TotalValue);
                    /*}}}*/
                }
                /*}}}*/
            }
            /*}}}*/
        }
        /*}}}*/
    }
    else
        abort();
}
/*}}}*/
/*}}}*/
