/* @(#)conndx11.h	1.1 3/25/91 */

/* conndx11.h */
/* Copyright Inmos Ltd - 1989 */
/* mapping from Inmos Dx11 C compiler thread concurrency model to icc concurrency model */

#include <semaphor.h>
#include <channel.h>
#include <process.h>

#define CHAN Channel
#define SEMA Semaphore
#define THREAD_NOTURG 1
#define THREAD_URGENT 0

#pragma IMS_translate(thread_create, "thread_create%c")
#pragma IMS_translate(thread_start, "thread_start%c")
#pragma IMS_translate(thread_restart, "thread_restart%c")
#pragma IMS_translate(chan_reset, "chan_reset%c")
#pragma IMS_translate(chan_in_byte_t, "chan_in_byte_t%c")
#pragma IMS_translate(chan_in_word_t, "chan_in_word_t%c")
#pragma IMS_translate(chan_in_message_t, "chan_in_message_t%c")
#pragma IMS_translate(chan_out_byte_t, "chan_out_byte_t%c")
#pragma IMS_translate(chan_out_word_t, "chan_out_word_t%c")
#pragma IMS_translate(chan_out_message_t, "chan_out_message_t%c")
#pragma IMS_translate(sema_signal_n, "sema_signal_n%c")
#pragma IMS_translate(sema_wait_n, "sema_wait_n%c")

extern char *thread_create(void (* /*fn*/)(), int /*wssize*/, 
                           int /*nargs*/, ...);
extern void  thread_start(void (* /*fn*/)(), char * /*ws*/, 
                          int /*wssize*/, int /*flags*/,
                          int /*nargs*/, ...);
extern void  thread_restart(char * /*p*/);
extern char *chan_reset(Channel * /*chan*/);
extern int   chan_in_byte_t(char * /*b*/, Channel * /*chan*/, 
                            int /*timeout*/);
extern int   chan_in_word_t(int * /*w*/, Channel * /*chan*/, 
                            int /*timeout*/);
extern int   chan_in_message_t(int /*l*/, char * /*b*/, 
                               Channel * /*chan*/, int /*timeout*/);
extern int   chan_out_byte_t(char /*b*/, Channel * /*chan*/, 
                             int /*timeout*/);
extern int   chan_out_word_t(int /*w*/, Channel * /*chan*/, 
                             int /*timeout*/);
extern int   chan_out_message_t(int /*l*/, char * /*b*/, 
                                Channel * /*chan*/, int /*timeout*/);
extern void  sema_signal_n(Semaphore * /*s*/, int /*n*/);
extern void  sema_wait_n(Semaphore * /*s*/, int /*n*/);

#define chan_init(chan)  ChanInit(chan)

#define chan_in_byte(b, chan) *(b) =  ChanInChar(chan)

#define chan_in_word(w, chan) *(w) =  ChanInInt(chan)

#define chan_in_message(l, b, chan)  ChanIn(chan, b, l)

#define chan_out_byte(b, chan)  ChanOutChar(chan, b)

#define chan_out_word(w, chan)  ChanOutInt(chan, w)

#define chan_out_message(l, b, chan)  ChanOut(chan, b, l)

#define par_malloc malloc

#define par_free free

#define par_fprintf fprintf

#define par_printf printf

#define timer_after(t1, t2)  ProcTimeAfter(t1, t2)

#define timer_delay(d) ProcWait(d)

#define timer_now()  ProcTime()

#define timer_wait(t) ProcAfter(t)

#define sema_init(s, v)  SemInit(s, v)

#define sema_signal(s)  SemSignal(s)

#define sema_wait(s)  SemWait(s)

#define thread_priority()  ProcGetPriority()

#define thread_deschedule()  ProcReschedule()

#define thread_stop() { __asm { stopp; } }
