/*
-- ----------------------------------------------------------------------------
--
--     Object Name : setconf.inc
--     Revision    : 1
--
--     (c) Copyright INMOS Limited, 1990.
--     All Rights Reserved.
--
--     DESCRIPTION
--         Include file of INMOS 'C' configurer defaults.
--
--     NOTES
--         None.
--
--     HISTORY
--         1-Jun-1990    Antony King    Created file.
--
-- ----------------------------------------------------------------------------
*/

/*{{{  Constant definitions */
val false 0;
val true  1;

val high 0;
val low  1;

val FALSE false;
val TRUE  true;

val HIGH high;
val LOW  low;
/*}}}*/

/*{{{  Hardware definitions */
define node (element = "processor") processor;

define processor (type = "T805") t805;
define processor (type = "T801") t801;
define processor (type = "T800") t800;
define processor (type = "T425") t425;
define processor (type = "T414") t414;
define processor (type = "T400") t400;
define processor (type = "T225") t225;
define processor (type = "T222") t222;
define processor (type = "T212") t212;
define processor (type = "M212") m212;

define node (element = "processor") PROCESSOR;

define PROCESSOR (type = "T805") T805;
define PROCESSOR (type = "T801") T801;
define PROCESSOR (type = "T800") T800;
define PROCESSOR (type = "T425") T425;
define PROCESSOR (type = "T414") T414;
define PROCESSOR (type = "T400") T400;
define PROCESSOR (type = "T225") T225;
define PROCESSOR (type = "T222") T222;
define PROCESSOR (type = "T212") T212;
define PROCESSOR (type = "M212") M212;
/*}}}*/

/*{{{  Software definitions */
define node (element = "process") process;

define node (element = "process", priority = high) highprocess;
define node (element = "process", priority = low)  lowprocess;

define node (element = "process") PROCESS;

define node (element = "process", priority = HIGH) HIGHPROCESS;
define node (element = "process", priority = LOW)  LOWPROCESS;
/*}}}*/

/*{{{  Network to host link */
edge host;
/*}}}*/
