/* @(#)stdiored.h	1.1 3/25/91 */

/* stdiored.h: reduced version of stdio */
/* Copyright (C) Codemist Ltd. */
/* Copyright (C) Inmos Ltd. 1989 */

/*
 * stdiored.h declares enough so that sprintf and sscanf can be provided
 * in the reduced library.
 */

#ifndef __stdiored_h
#define __stdiored_h

#include <subsem.h>

#ifndef __size_t
#define __size_t 1
typedef unsigned int size_t;   /* from <stddef.h> */
#endif

typedef char *__va_list[1];       /* keep in step with <stdarg.h> */

#ifndef NULL
#  define NULL (void *)0                /* see <stddef.h> */
#endif

typedef struct __extradata {
  unsigned char __lilbuf[2]; /* single byte buffer for them that want it  */
                             /* plus an unget char is put in __lilbuf[1]   */
  long _lspos;               /* what __pos should be (set after lazy seek) */
  unsigned char *__extent;   /* extent of writes into the current buffer  */
  int __buflim;              /* used size of buffer                       */
  int __savedicnt;           /* after unget contains old icnt             */
  int __savedocnt;           /* after unget contains old ocnt             */
  _IMS_Semaphore __sem;      /* protect stdio in concurrent environment   */
} _extradata, *_extradatap;

typedef struct __FILE_struct
{ unsigned char *__ptr;
  int __icnt;                   /* two separate _cnt fields so we can police ...        */
  int __ocnt;                   /* ... restrictions that read/write are fseek separated */
  int __flag;
  unsigned char *__base;        /* buffer base */
  int __file;                   /* file handle */
  long __pos;                   /* position in file */
  int __bufsiz;                 /* maximum buffer size */
  int __signature;              /* used with temporary files */
  struct __extradata *__extrap; /* pointer to information about stream */
} FILE;

#if _PTYPE != '2' && _PTYPE != '3'
#define BUFSIZ   (4096) /* system buffer size (as used by setbuf) */
#else
#define BUFSIZ   (1024) /* system buffer size (as used by setbuf) */
#endif
#define EOF      (-1)

#pragma IMS_on(printf_checking)

extern int sprintf(char * /*s*/, const char * /*format*/, ...);

#pragma IMS_off(printf_checking)
#pragma IMS_on(scanf_checking)

extern int sscanf(const char * /*s*/, const char * /*format*/, ...);

#pragma IMS_off(scanf_checking)

extern int vsprintf(char * /*s*/, const char * /*format*/, __va_list /*arg*/);

/* All the following are required to provide sprintf, scanf and co in the
 * reduced libary 
 */

#define getc(p) *((p)->__ptr)++

#define putc(ch, p) (*((p)->__ptr)++ = (ch))

#endif

/* end of stdiored.h */
