/* @(#)subsem.h	1.1 3/25/91 */

/* subsem.h */
/* Copyright (C) Inmos Ltd. 1989, 1990, 1991 */

#ifndef _subsem_h
#define _subsem_h

#include <subchan.h>

typedef	struct _IMS_SemPacket _IMS_SemPacket;
typedef	struct _IMS_Sim_Semaphore _IMS_Sim_Semaphore;
typedef	struct _IMS_Semaphore _IMS_Semaphore;

struct _IMS_SemPacket 
       {
         _IMS_Channel     __post;   /* synchronisation channel */
	 _IMS_SemPacket  *__next;   /* pointer to next packet in sem chain */
       };

struct _IMS_Sim_Semaphore 
       {
 	 unsigned int    __value; 	/* value of semaphore */
	 _IMS_SemPacket  *__head;	/* Head of list of waiting processes */
	 _IMS_SemPacket  *__tail;	/* Tail of list of waiting processes */
       };

struct _IMS_Semaphore 
       {
 	 unsigned int       __value;    /* value of semaphore */
	 _IMS_SemPacket    *__head;     /* Head of list of waiting processes */
	 _IMS_SemPacket    *__tail;     /* Tail of list of waiting processes */
         _IMS_Sim_Semaphore __lo_sem;   /* low priority exclusion semaphore */
         _IMS_Sim_Semaphore __hi_sem;   /* high priority exclusion semaphore */
         int                __lo_using; /* flag to indicate use by low pri process */
         _IMS_Channel       __hi_chan;  /* high priority exclusion channel */
       };

#endif

