/* Hexadecimal op-codes for trap calls	*/
#define	__TRAP_4	"4e44"
#define	__TRAP_5	"4e45"
#define	__TRAP_8	"4e48"
#define	__TRAP_12	"4e4c"

/* Constants used to represent opcodes in trap #8 routine. 		*/
#define	_READ		1	/* Read a block from the transputer 	*/
#define	_WRITE		2	/* Write a block to the transputer 	*/
#define	_RESET		3	/* Reset transputer & link adapter 	*/
#define	_ANALYSE	4	/* Analyse the transputer 		*/
#define	_RESETLNK	5	/* Reset link adapter only 		*/
#define	_WRRDY		6	/* Test if Transputer ready to RX data 	*/
#define	_RDRDY		7	/* Test if Transputer ready to TX data 	*/
#define	_LNKSWTCH	8	/* Switch ACSILA link 			*/
#define	_RESETNDS	9	/* Reset nodes on diagnostics bus 	*/
#define	_R_A_NDS	10	/* Reset/analyse nodes 			*/
#define	_SETSYSVAR	11	/* Set system variables for ACSILA 	*/
#define	_LINKMODE	12	/* Set ACSILA link mode 		*/
#define	_SET_R_A	13	/* Set reset and or analyse on a list of nodes */
#define	_ANALNDS	14	/* Analyse n nodes			*/
#define	_TEST_ERR	15	/* Test state of error line		*/
#define	_RD_SYSVAR	16	/* Read system variables		*/

/* Further codes for _SETSYSVAR (set system variables) and 		*/
/* _RD_SYSVAR calls							*/
#define	_SETTO		0	/* Set/read link transfer timeout in 200 ms ticks */
#define	_SETNDN		1	/* Set/read number of diagnostics nodes (length of diag chain) */
#define	_SETSR		2	/* Set/read number of nodes for server to reset on startup */
#define _RDLM		16	/* Read link mode			*/

/* Constants used to set error flag to return to functions 		*/
#define	SUCCESS		1	/* successful termination of function 	*/
#define	FAIL		0	/* UN-successful termination of function */

/* Maximum single transfer size in mode 2 */
#define _max_packet	65536

long	trap8(long,long,void *);
long	trap8x(long,long,long,void *);

#pragma	inline	d0=trap8(d1,d0,a0) {__TRAP_8}
#pragma	inline	d0=trap8x(d1,d2,d0,a0) {__TRAP_8}
