!
! FILER.INC
!
! Interface to "alien filer" process
!
! Rev 004 NPH 26-Apr-1987 forced to remove %spec for TT Out/In as compiler
!                         gets %spec followed by definition wrong.
!
! Rev 003 NPH 27-Oct-1987 add afserver interface routine specs
!
! Rev 002 ADC 23-Jul-1987 add new CMD codes invented in later afserver's
!
! Rev 001 IAY 25-Jun-1987 [SCR/87/259] track Inmos name changes in the
!                         various filer termination commands

!
! Routine specs for Fileio routines to interface at a high level to Afserver
!

%external %routine %spec Get Integer  %alias "IMP_GET_INTEGER" -
                                     ( %integer %name I )

%external %routine %spec Put Integer  %alias "IMP_PUT_INTEGER" -
                                     ( %integer I )

%external %routine %spec Get Record   %alias "IMP_GET_RECORD" -
                                     ( %integer %name Len, %integer Buf Addr )

%external %routine %spec Put Record   %alias "IMP_PUT_RECORD" -
                                     ( %integer Len, Buf Addr )

%external %routine %spec Check Result %alias "IMP_CHECK_RESULT"

!04! %external %integer %spec TT Out Stream Id %alias "IMP___TT_OUT_STREAM_ID"
!04! %external %integer %spec TT In  Stream Id %alias "IMP___TT_IN_STREAM_ID"

!
! Command constants
!
%const %integer Alien Terminate Cmd       = 0   {001}
%const %integer Open File Cmd             = 1
%const %integer Open Temp Cmd             = 2
%const %integer Open Input Stream Cmd     = 3
%const %integer Open Output Stream Cmd    = 4
%const %integer Stream Access Cmd         = 5
%const %integer Stream Status Cmd         = 6
%const %integer Stream File Cmd           = 7
%const %integer Stream Length Cmd         = 8
%const %integer Stream Max Recl Cmd       = 9
%const %integer Stream Min Recl Cmd       = 10
%const %integer Close Stream Cmd          = 11

%const %integer Read Block Cmd            = 12
%const %integer Write Block Cmd           = 13
%const %integer Seek Cmd                  = 14

%const %integer Read Record Cmd           = 15
%const %integer Write Record Cmd          = 16
%const %integer Backspace Cmd             = 17
%const %integer Rewind Cmd                = 18
%const %integer Fast Forward Cmd          = 19
%const %integer Truncate Cmd              = 20

%const %integer Read Direct Record Cmd    = 21
%const %integer Write Direct Record Cmd   = 22

%const %integer Terminate Cmd             = 24 {001}

%const %integer Set Result Cmd            = 25 {002}
%const %integer Run Command Cmd           = 26 {002}
%const %integer Rename File Cmd           = 27 {002}
%const %integer Read Time Cmd             = 28 {002}
%const %integer Read Key Cmd              = 29 {002}
%const %integer Receive Block Cmd         = 30 {002}
%const %integer Send Block Cmd            = 31 {002}
%const %integer Call Interrupt Cmd        = 32 {002}
%const %integer Read Regs Cmd             = 33 {002}
%const %integer Run Time Data Cmd         = 34 {002}
%const %integer Read Environment Cmd      = 35 {002}

!
! File access modes
!
%const %integer Binary Access             = 0
%const %integer Text   Access             = 1

!
! Open modes
!
%const %integer Read   Mode               = 0
%const %integer Write  Mode               = 1
%const %integer Update Mode               = 2

!
! Exists modes
!
%const %integer Old File                  = 0
%const %integer New File                  = 1

!
! Close Options
!
%const %integer Close Option              = 0
%const %integer Close Del Option          = 1

!
! Errors
!
%const %integer Operation OK              = 0
%const %integer End of File               = 1

%const %integer File Name Too Long Err    = 2
%const %integer Invalid Access Method Err = 3
%const %integer Invalid Open Mode Err     = 4
%const %integer Invalid Exist Mode Err    = 5
%const %integer Invalid Record Length Err = 6
%const %integer Invalid Std Stream Err    = 7
%const %integer Invalid Stream Id Err     = 8
%const %integer Invalid Close Option Err  = 9
%const %integer No Seek Possible Err      = 10
%const %integer Invalid Record Number Err = 11

%const %integer Operation Failed Err      = 99   {General failure}

!
! Protocol tag values
!
%const %integer Bool Value                = 0
%const %integer Byte Value                = 1
%const %integer Int Value                 = 2
%const %integer Int16 Value               = 3
%const %integer Int32 Value               = 4
%const %integer Int64 Value               = 5
%const %integer Real32 Value              = 6
%const %integer Real64 Value              = 7
%const %integer Nil Record Value          = 8
%const %integer Record8 Value             = 9
%const %integer Record Value              = 10
%const %integer Record16 Value            = 11
%const %integer Record32 Value            = 12

%end %of %file
