!!!!!!!!!!!!!!  Standard Video Terminal Interface  !!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Hamish Dewar   EU Computer Science Department   January 1983 !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! **** PROVISIONAL SPECIFICATION SUBJECT TO MINOR CHANGE ****
! This version is implemented wholly as an external library,
! with re-definition of the various input/output procedures.
! IT handles the standardisation of vdu operations and implements
! the concept of a bounding box or frame applied to the screen.
! Only the following I/O procedures are covered:-
!   SELECT INPUT, SELECT OUTPUT, PROMPT,
!   PRINT SYMBOL, SPACE(S), NEWLINE(S), PRINT STRING, WRITE,
!   READ SYMBOL, SKIP SYMBOL, NEXT SYMBOL, READ (integer only)
! The following video functions are provided:-
!   CLEAR LINE (ie rest of line), CLEAR FRAME, SCROLL, AT/GOTOXY,
!   SET FRAME, SET MODE, SET SHADE, SET VIDEO MODE,
!   PUSH WINDOW, POP WINDOW, SWOP WINDOW
! The routine DEFINE VIDEO is included for convenience at present.
!!!!!!!!!!!!!!!!!!!!!!!   INTERFACE   !!!!!!!!!!!!!!!!!!!!!!!!!!
%constinteger BS=8, LF=10, FF=12, RT=13, ESC=27;  !ASCII control chars
%constinteger DEL=127
! Video mode options (*not all implemented*):-
%constinteger SINGLE=1<<0, MAPLOWER=1<<1, NOECHO=1<<2, PASSDEL=1<<3,
              NOTYPEAHEAD=1<<4, NOTERMECHO=1<<5,
              CONTROLTERM=1<<6, NOEVENT9=1<<7,
              LEAVECONTROLS=1<<8, LEAVELF=1<<9,
              LEAVERT=1<<10, NOFLUSH=1<<11, NOBUFFER=1<<12,
              SPECIALPAD=1<<13, NODELECHO=1<<14,
              NEWTCP=1<<29 {temp}
! Video FUNction/MODE flag values:-
%constinteger INTENSE=1, REVERSE=2, UNDERLINE=4, BLINK=8,
              GRAPHICAL=16, SHADE=31
%constinteger FULLSCROLL=64, ANYSCROLL=128;  !FUN only
%constinteger NOSCROLL=64, FREEZE=128;       !MODE only
%constinteger SCREENMODE=controlterm+notermecho+leavecontrols
%recordformat WININFO(%byteinteger top,rows,left,cols,row,col,fun,mode)
%externalrecord(wininfo)%spec VDU;  !full-screen frame
%externalrecord(wininfo)%spec WIN;  !current frame
%externalintegerspec LEADIN
!
%externalroutinespec DEFINE VIDEO    %alias "VTDEFVIDEO"(%integer emastype)
%constinteger VISUAL200=11
%externalroutinespec SET VIDEO MODE  %alias "VTSETVIDEO"(%integer mode)
%externalroutinespec SET FRAME       %alias "VTSETFRAME"(%integer t,r,l,c)
%externalroutinespec SET SHADE       %alias "VTSETSHADE"(%integer s)
%externalroutinespec SET MODE        %alias "VTSETMODE"(%integer m)
%externalroutinespec CLEAR LINE      %alias "VTCROL"
%externalroutinespec CLEAR FRAME     %alias "VTCFRAME"
%externalroutinespec SCROLL          %alias "VTSCROLL"(%integer t,b,n)
%externalroutinespec AT              %alias "VTSETCURSOR"(%integer row,col)
%externalroutinespec GOTOXY          %alias "VTGOTOXY"(%integer x,y)
%externalroutinespec PUSH WINDOW     %alias "VTPUSH"
%externalroutinespec POP WINDOW      %alias "VTPOP"
%externalroutinespec SWOP WINDOW     %alias "VTSWOP"
!
%externalroutinespec SELECT INPUT    %alias "VTSELIN"(%integer i)
%externalroutinespec SELECT OUTPUT   %alias "VTSELOUT"(%integer i)
%externalroutinespec PRINT SYMBOL    %alias "VTPSYM"(%integer sym)
%externalroutinespec SPACE           %alias "VTSP"
%externalroutinespec SPACES          %alias "VTSPS"(%integer n)
%externalroutinespec NEWLINE         %alias "VTNL"
%externalroutinespec NEWLINES        %alias "VTNLS"(%integer n)
%externalroutinespec PRINT STRING    %alias "VTPSTRING"(%string(255) s)
%externalroutinespec WRITE           %alias "VTWRITE"(%integer v,p)
%externalroutinespec PROMPT          %alias "VTPROMPT"(%string(255) s)
%externalroutinespec READ SYMBOL     %alias "VTRSYM"(%integername k)
%externalintegerfnspec NEXT SYMBOL   %alias "VTNSYM"
%externalroutinespec SKIP SYMBOL     %alias "VTSSYM"
%externalroutinespec READ            %alias "VTREAD"(%integername v)
!
%endoffile
