!
! >>> OBJDEF.INC <<<
!
! IMP equivalent of the OBJDEF macro.
!

!
! Record types
!
%const %integer OBJ C HDR                = 0,  {header records}
                OBJ C GSD                = 1,  {global symbol descriptor}
                OBJ C TIR                = 2,  {text/information/relocation}
                OBJ C EOM                = 3,  {end of module}
                OBJ C DBG                = 4,  {debugger information}
                OBJ C TBT                = 5,  {traceback information}
                OBJ C LNK                = 6,  {link option specification}
                OBJ C EOMW               = 7,  {end of module / word psect}
                OBJ C MAXRECTYP          = 7

%const %integer OBJ C EOM SUCCESS        = 0,
                OBJ C EOM WARNING        = 1,
                OBJ C EOM ERROR          = 2,
                OBJ C EOM ABORT          = 3

%const %integer MHD C MHD                = 0,  {main module header}
                MHD C LNM                = 1,  {language processor name}
                MHD C SRC                = 2,  {source file header}
                MHD C TTL                = 3,  {title text header}
                MHD C CPR                = 4,  {copyright header}
                MHD C MTC                = 5,  {maintenance status header}
                MHD C GTX                = 6   {general text header}

%const %integer GSD C PSC                = 0,  {program section definition}
                GSD C SYM                = 1,  {global symbol}
                GSD C EPM                = 2,  {entry point and mask}
                GSD C PRO                = 3,  {procedure w/formal args}
                GSD C SYMW               = 4,  {symbol def/word psect}
                GSD C EPMW               = 5,  {entry point/word psect}
                GSD C PROW               = 6,  {procedure def/word psect}
                GSD C IDC                = 7,  {entity ident consistency}
                GSD C ENV                = 8,  {environment def/ref}
                GSD C LSY                = 9,  {local symbol def/ref}
                GSD C LEPM               = 10, {local entry point def}
                GSD C LPRO               = 11, {local procedure def}
                GSD C SPSC               = 12  {psect def in shareable image}

%const %integer TIR C STA GBL            = 0,
                TIR C STA SB             = 1,
                TIR C STA SW             = 2,
                TIR C STA LW             = 3,
                TIR C STA PB             = 4,
                TIR C STA PW             = 5,
                TIR C STA PL             = 6,
                TIR C STA UB             = 7,
                TIR C STA UW             = 8,
                TIR C STA BFI            = 9,
                TIR C STA WFI            = 10,
                TIR C STA LFI            = 11,
                TIR C STA EPM            = 12,
                TIR C STA CKARG          = 13,
                TIR C STA WPB            = 14,
                TIR C STA WPW            = 15,
                TIR C STA WPL            = 16,
                TIR C STA LSY            = 17,
                TIR C STA LIT            = 18,
                TIR C STA LEPM           = 19,
                TIR C MAXSTACOD          = 19

%const %integer TIR C MINSTOCOD          = 20,
                TIR C STO SB             = 20,
                TIR C STO SW             = 21,
                TIR C STO L              = 22,
                TIR C STO BD             = 23,
                TIR C STO WD             = 24,
                TIR C STO LD             = 25,
                TIR C STO LI             = 26,
                TIR C STO PIDR           = 27,
                TIR C STO PICR           = 28,
                TIR C STO RSB            = 29,
                TIR C STO RSW            = 30,
                TIR C STO RL             = 31,
                TIR C STO VPS            = 32,
                TIR C STO USB            = 33,
                TIR C STO USW            = 34,
                TIR C STO RUB            = 35,
                TIR C STO RUW            = 36,
                TIR C STO B              = 37,
                TIR C STO W              = 38,
                TIR C STO RB             = 39,
                TIR C STO RW             = 40,
                TIR C STO RIVB           = 41,
                TIR C STO PIRR           = 42,
                TIR C MAXSTOCOD          = 42 

%const %integer TIR C MINOPRCOD          = 50,
                TIR C OPR NOP            = 50,
                TIR C OPR ADD            = 51,
                TIR C OPR SUB            = 52,
                TIR C OPR MUL            = 53,
                TIR C OPR DIV            = 54,
                TIR C OPR AND            = 55,
                TIR C OPR IOR            = 56,
                TIR C OPR EOR            = 57,
                TIR C OPR NEG            = 58,
                TIR C OPR COM            = 59,
                TIR C OPR INSV           = 60,
                TIR C OPR ASH            = 61,
                TIR C OPR USH            = 62,
                TIR C OPR ROT            = 63,
                TIR C OPR SEL            = 64,
                TIR C OPR REDEF          = 65,
                TIR C OPR DFLIT          = 66,
                TIR C MAXOPRCOD          = 66 

%const %integer TIR C MINCTLCOD          = 80,
                TIR C CTL SETRB          = 80,
                TIR C CTL AUGRB          = 81,
                TIR C CTL DFLOC          = 82,
                TIR C CTL STLOC          = 83,
                TIR C CTL STKDL          = 84,
                TIR C MAXCTLCOD          = 84 

%end %of %file

! lots not yet converted to follow...
 $DEF	OBJ$B RECTYP	.BLKB
 $DEF	OBJ$C SUBTYP
 $DEF	OBJ$K SUBTYP
 $DEF	OBJ$B SUBTYP	.BLKB
 $DEF	OBJ$B MHD STRLV	.BLKB
 $DEF	OBJ$W MHD RECSZ	.BLKW
 %const %integer OBJ C MAXRECSIZ	<^X800>
OBJ$C STRLVL	0
OBJ$C SYMSIZ	31
OBJ$C STOREPLIM	<^XFFFFFFFF>
OBJ$C PSCALILIM	9

 $DEF	OBJ$T MHD NAME
 	$DEFEND	OBJ,$GBL,RECDEF

 	.ENDM	$OBJRECDEF

 	.MACRO	$MHDDEF,$GBL

 	$DEFINI	MHD,$GBL


 $DEF	MHD$B RECTYP	.BLKB
MHD$C MHD	0
MHD$C LNM	1
MHD$C SRC	2
MHD$C TTL	3
MHD$C CPR	4
MHD$C MTC	5
MHD$C GTX	6
MHD$C MAXHDRTYP	6
 $DEF	MHD$B HDRTYP	.BLKB
 $DEF	MHD$B STRLVL	.BLKB
 $DEF	MHD$W RECSIZ	.BLKW
 $DEF	MHD$B NAMLNG	.BLKB
MHD$S NAME	31
 ;
 ;
 ;
 $DEF	MHD$T NAME	.BLKB	31

 	$DEFEND	MHD,$GBL,DEF

 	.ENDM	$MHDDEF

 	$DEFINI	EOMW,$GBL


 $DEF	EOMW$B RECTYP	.BLKB
 $DEF	EOMW$B COMCOD	.BLKB
 $DEF	EOMW$C EOMMIN
 $DEF	EOMW$K EOMMIN
 $DEF	EOMW$W PSINDX	.BLKW
 $DEF	EOMW$L TFRADR	.BLKL
 $DEF	EOMW$C EOMMX1
 $DEF	EOMW$K EOMMX1
EOMW$V WKTFR	0
EOMW$M WKTFR	1
 $DEF	EOMW$B TFRFLG	.BLKB
 $DEF	EOMW$C EOMMAX

 $DEF	EOMW$K EOMMAX
 	$DEFEND	EOMW,$GBL,DEF

 	.ENDM	$EOMWDEF


 	.MACRO	$GSDDEF,$GBL

 	$DEFINI	GSD,$GBL


 $DEF	GSD$B RECTYP	.BLKB
 $DEF	GSD$C ENTRIES
 $DEF	GSD$K ENTRIES
GSD$C PSC	0
GSD$C SYM	1
GSD$C EPM	2
GSD$C PRO	3
GSD$C SYMW	4
GSD$C EPMW	5
GSD$C PROW	6
GSD$C IDC	7
GSD$C ENV	8
GSD$C LSY	9
GSD$C LEPM	10
GSD$C LPRO	11
GSD$C SPSC	12
GSD$C MAXRECTYP	12
 $DEF	GSD$B GSDTYP	.BLKB

 	$DEFEND	GSD,$GBL,DEF

 	.ENDM	$GSDDEF

 	.MACRO	$GPSDEF,$GBL

 	$DEFINI	GPS,$GBL


 $DEF	GPS$T START
 $DEF	GPS$B GSDTYP	.BLKB
 $DEF	GPS$B ALIGN	.BLKB
GPS$V PIC	0
GPS$M PIC	1
GPS$V LIB	1
GPS$M LIB	2
GPS$V OVR	2
GPS$M OVR	4
GPS$V REL	3
GPS$M REL	8
GPS$V GBL	4
GPS$M GBL	16
GPS$V SHR	5
GPS$M SHR	32
GPS$V EXE	6
GPS$M EXE	64
GPS$V RD	7
GPS$M RD	128
GPS$V WRT	8
GPS$M WRT	256
GPS$V VEC	9
GPS$M VEC	<^X200>
 $DEF	GPS$W FLAGS	.BLKW
 $DEF	GPS$L ALLOC	.BLKL
 $DEF	GPS$B NAMLNG	.BLKB
 $DEF	GPS$C NAME
 $DEF	GPS$K NAME
GPS$S NAME	31
 $DEF	GPS$T NAME	.BLKB	31

 	$DEFEND	GPS,$GBL,DEF

 	.ENDM	$GPSDEF
 	.MACRO	$SGPSDEF,$GBL

 	$DEFINI	SGPS,$GBL


 $DEF	SGPS$T START
 $DEF	SGPS$B GSDTYP	.BLKB
 $DEF	SGPS$B ALIGN	.BLKB
SGPS$V PIC	0
SGPS$M PIC	1
SGPS$V LIB	1
SGPS$M LIB	2
SGPS$V OVR	2
SGPS$M OVR	4
SGPS$V REL	3
SGPS$M REL	8
SGPS$V GBL	4
SGPS$M GBL	16
SGPS$V SHR	5
SGPS$M SHR	32
SGPS$V EXE	6
SGPS$M EXE	64
SGPS$V RD	7
SGPS$M RD	128
SGPS$V WRT	8
SGPS$M WRT	256
SGPS$V VEC	9
SGPS$M VEC	<^X200>
 $DEF	SGPS$W FLAGS	.BLKW
 $DEF	SGPS$L ALLOC	.BLKL
 $DEF	SGPS$L BASE	.BLKL
 $DEF	SGPS$B NAMLNG	.BLKB
 $DEF	SGPS$C NAME
 $DEF	SGPS$K NAME
SGPS$S NAME	31
 $DEF	SGPS$T NAME	.BLKB	31

 	$DEFEND	SGPS,$GBL,DEF

 	.ENDM	$SGPSDEF

 	.MACRO	$GSYDEF,$GBL

 	$DEFINI	GSY,$GBL


 $DEF	GSY$T START
 $DEF	GSY$B GSDTYP	.BLKB
 $DEF	GSY$B DATYP	.BLKB
GSY$V WEAK	0
GSY$M WEAK	1
GSY$V DEF	1
GSY$M DEF	2
GSY$V UNI	2
GSY$M UNI	4
GSY$V REL	3
GSY$M REL	8
 $DEF	GSY$W FLAGS	.BLKW

 	$DEFEND	GSY,$GBL,DEF

 	.ENDM	$GSYDEF
 	.MACRO	$SRFDEF,$GBL

 	$DEFINI	SRF,$GBL


 $DEF	SRF$T START
 $DEF	SRF$B GSDTYP	.BLKB
 $DEF	SRF$B DATYP	.BLKB
 $DEF	SRF$W FLAGS	.BLKW
 $DEF	SRF$B NAMLNG	.BLKB
 $DEF	SRF$C NAME
 $DEF	SRF$K NAME
SRF$S NAME	31
 $DEF	SRF$T NAME	.BLKB	31

 	$DEFEND	SRF,$GBL,DEF

 	.ENDM	$SRFDEF
 	.MACRO	$SDFDEF,$GBL

 	$DEFINI	SDF,$GBL


 $DEF	SDF$T START
 $DEF	SDF$B GSDTYP	.BLKB
 $DEF	SDF$B DATYP	.BLKB
 $DEF	SDF$W FLAGS	.BLKW
 $DEF	SDF$B PSINDX	.BLKB
 $DEF	SDF$L VALUE	.BLKL
 $DEF	SDF$B NAMLNG	.BLKB
 $DEF	SDF$C NAME
 $DEF	SDF$K NAME
SDF$S NAME	31
 $DEF	SDF$T NAME	.BLKB	31

 	$DEFEND	SDF,$GBL,DEF

 	.ENDM	$SDFDEF
 	.MACRO	$EPMDEF,$GBL

 	$DEFINI	EPM,$GBL


 $DEF	EPM$T START
 $DEF	EPM$B GSDTYP	.BLKB
 $DEF	EPM$B DATYP	.BLKB
 $DEF	EPM$W FLAGS	.BLKW
 $DEF	EPM$B PSINDX	.BLKB
 $DEF	EPM$L ADDRS	.BLKL
 $DEF	EPM$W MASK	.BLKW
 $DEF	EPM$B NAMLNG	.BLKB
 $DEF	EPM$C NAME
 $DEF	EPM$K NAME
EPM$S NAME	31
 $DEF	EPM$T NAME	.BLKB	31

 	$DEFEND	EPM,$GBL,DEF

 	.ENDM	$EPMDEF
 	.MACRO	$PRODEF,$GBL

 	$DEFINI	PRO,$GBL


 $DEF	PRO$T START
 $DEF	PRO$B GSDTYP	.BLKB
 $DEF	PRO$B DATYP	.BLKB
 $DEF	PRO$W FLAGS	.BLKW
 $DEF	PRO$B PSINDX	.BLKB
 $DEF	PRO$L ADDRS	.BLKL
 $DEF	PRO$W MASK	.BLKW
 $DEF	PRO$B NAMLNG	.BLKB
 $DEF	PRO$C NAME
 $DEF	PRO$K NAME
PRO$S NAME	31
 $DEF	PRO$T NAME	.BLKB	31

 	$DEFEND	PRO,$GBL,DEF

 	.ENDM	$PRODEF
 	.MACRO	$FMLDEF,$GBL

 	$DEFINI	FML,$GBL


 $DEF	FML$B MINARGS	.BLKB
 $DEF	FML$B MAXARGS	.BLKB
 $DEF	FML$C SIZE

 $DEF	FML$K SIZE
 	$DEFEND	FML,$GBL,DEF

 	.ENDM	$FMLDEF
 	.MACRO	$ARGDEF,$GBL

 	$DEFINI	ARG,$GBL


ARG$V PASSMECH	0
ARG$S PASSMECH	2
ARG$C UNKNOWN	0
ARG$C VALUE	1
ARG$C REF	2
ARG$C DESC	3
 $DEF	ARG$B VALCTL	.BLKB
 $DEF	ARG$B BYTECNT	.BLKB
 $DEF	ARG$C SIZE

 $DEF	ARG$K SIZE
 	$DEFEND	ARG,$GBL,DEF

 	.ENDM	$ARGDEF

 	.MACRO	$SDFWDEF,$GBL

 	$DEFINI	SDFW,$GBL


 $DEF	SDFW$T START
 $DEF	SDFW$B GSDTYP	.BLKB
 $DEF	SDFW$B DATYP	.BLKB
 $DEF	SDFW$W FLAGS	.BLKW
 $DEF	SDFW$W PSINDX	.BLKW
 $DEF	SDFW$L VALUE	.BLKL
 $DEF	SDFW$B NAMLNG	.BLKB
 $DEF	SDFW$C NAME
 $DEF	SDFW$K NAME
SDFW$S NAME	31
 $DEF	SDFW$T NAME	.BLKB	31

 	$DEFEND	SDFW,$GBL,DEF

 	.ENDM	$SDFWDEF
 	.MACRO	$EPMWDEF,$GBL

 	$DEFINI	EPMW,$GBL


 $DEF	EPMW$T START
 $DEF	EPMW$B GSDTYP	.BLKB
 $DEF	EPMW$B DATYP	.BLKB
 $DEF	EPMW$W FLAGS	.BLKW
 $DEF	EPMW$W PSINDX	.BLKW
 $DEF	EPMW$L ADDRS	.BLKL
 $DEF	EPMW$W MASK	.BLKW
 $DEF	EPMW$B NAMLNG	.BLKB
 $DEF	EPMW$C NAME
 $DEF	EPMW$K NAME
EPMW$S NAME	31
 $DEF	EPMW$T NAME	.BLKB	31

 	$DEFEND	EPMW,$GBL,DEF

 	.ENDM	$EPMWDEF
 	.MACRO	$PROWDEF,$GBL

 	$DEFINI	PROW,$GBL


 $DEF	PROW$T START
 $DEF	PROW$B GSDTYP	.BLKB
 $DEF	PROW$B DATYP	.BLKB
 $DEF	PROW$W FLAGS	.BLKW
 $DEF	PROW$W PSINDX	.BLKW
 $DEF	PROW$L ADDRS	.BLKL
 $DEF	PROW$W MASK	.BLKW
 $DEF	PROW$B NAMLNG	.BLKB
 $DEF	PROW$C NAME
 $DEF	PROW$K NAME
PROW$S NAME	31
 $DEF	PROW$T NAME	.BLKB	31

 	$DEFEND	PROW,$GBL,DEF

 	.ENDM	$PROWDEF
 	.MACRO	$IDCDEF,$GBL

 	$DEFINI	IDC,$GBL


 $DEF	IDC$B GSDTYP	.BLKB
IDC$V BINIDENT	0
IDC$V IDMATCH	1
IDC$S IDMATCH	2
IDC$V ERRSEV	3
IDC$S ERRSEV	3
IDC$C LEQ	0
IDC$C EQUAL	1
 $DEF	IDC$W FLAGS	.BLKW
 $DEF	IDC$B NAMLNG	.BLKB

 $DEF	IDC$T NAME
 	$DEFEND	IDC,$GBL,DEF

 	.ENDM	$IDCDEF
 	.MACRO	$ENVDEF,$GBL

 	$DEFINI	ENV,$GBL


 $DEF	ENV$B GSDTYP	.BLKB
ENV$V DEF	0
ENV$M DEF	1
 $DEF	ENV$W FLAGS	.BLKW
 $DEF	ENV$W ENVINDX	.BLKW
 $DEF	ENV$B NAMLNG	.BLKB
ENV$S NAME	31
 $DEF	ENV$T NAME	.BLKB	31

 	$DEFEND	ENV,$GBL,DEF

 	.ENDM	$ENVDEF
 	.MACRO	$LSYDEF,$GBL

 	$DEFINI	LSY,$GBL


 $DEF	LSY$T START
 $DEF	LSY$B GSDTYP	.BLKB
 $DEF	LSY$B DATYP	.BLKB
LSY$V WEAK	0
LSY$M WEAK	1
LSY$V DEF	1
LSY$M DEF	2
LSY$V UNI	2
LSY$M UNI	4
LSY$V REL	3
LSY$M REL	8
 $DEF	LSY$W FLAGS	.BLKW
 $DEF	LSY$W ENVINDX	.BLKW

 	$DEFEND	LSY,$GBL,DEF

 	.ENDM	$LSYDEF
 	.MACRO	$LSRFDEF,$GBL

 	$DEFINI	LSRF,$GBL


 $DEF	LSRF$T START
 $DEF	LSRF$B GSDTYP	.BLKB
 $DEF	LSRF$B DATYP	.BLKB
 $DEF	LSRF$W FLAGS	.BLKW
 $DEF	LSRF$W ENVINDX	.BLKW
 $DEF	LSRF$B NAMLNG	.BLKB
 $DEF	LSRF$C NAME
 $DEF	LSRF$K NAME
LSRF$S NAME	31
 $DEF	LSRF$T NAME	.BLKB	31

 	$DEFEND	LSRF,$GBL,DEF

 	.ENDM	$LSRFDEF
 	.MACRO	$LSDFDEF,$GBL

 	$DEFINI	LSDF,$GBL


 $DEF	LSDF$T START
 $DEF	LSDF$B GSDTYP	.BLKB
 $DEF	LSDF$B DATYP	.BLKB
 $DEF	LSDF$W FLAGS	.BLKW
 $DEF	LSDF$W ENVINDX	.BLKW
 $DEF	LSDF$W PSINDX	.BLKW
 $DEF	LSDF$L VALUE	.BLKL
 $DEF	LSDF$B NAMLNG	.BLKB
 $DEF	LSDF$C NAME
 $DEF	LSDF$K NAME
LSDF$S NAME	31
 $DEF	LSDF$T NAME	.BLKB	31

 	$DEFEND	LSDF,$GBL,DEF

 	.ENDM	$LSDFDEF
 	.MACRO	$LEPMDEF,$GBL

 	$DEFINI	LEPM,$GBL


 $DEF	LEPM$T START
 $DEF	LEPM$B GSDTYP	.BLKB
 $DEF	LEPM$B DATYP	.BLKB
 $DEF	LEPM$W FLAGS	.BLKW
 $DEF	LEPM$W ENVINDX	.BLKW
 $DEF	LEPM$W PSINDX	.BLKW
 $DEF	LEPM$L ADDRS	.BLKL
 $DEF	LEPM$W MASK	.BLKW
 $DEF	LEPM$B NAMLNG	.BLKB
 $DEF	LEPM$C NAME
 $DEF	LEPM$K NAME
LEPM$S NAME	31
 $DEF	LEPM$T NAME	.BLKB	31

 	$DEFEND	LEPM,$GBL,DEF

 	.ENDM	$LEPMDEF
 	.MACRO	$LPRODEF,$GBL

 	$DEFINI	LPRO,$GBL


 $DEF	LPRO$T START
 $DEF	LPRO$B GSDTYP	.BLKB
 $DEF	LPRO$B DATYP	.BLKB
 $DEF	LPRO$W FLAGS	.BLKW
 $DEF	LPRO$W ENVINDX	.BLKW
 $DEF	LPRO$W PSINDX	.BLKW
 $DEF	LPRO$L ADDRS	.BLKL
 $DEF	LPRO$W MASK	.BLKW
 $DEF	LPRO$B NAMLNG	.BLKB
 $DEF	LPRO$C NAME
 $DEF	LPRO$K NAME
LPRO$S NAME	31
 $DEF	LPRO$T NAME	.BLKB	31
