!
! IMP equivalent of $PCBDEF macro
!
%record %format PCB Fm ( -
   %record(PCB Fm) %name SQFL, SQBL,
   %short                SIZE,
   %byte                 TYPE, PRI,
   %byte                 ASTACT, ASTEN,
   %short                MTXCNT,
   %record(*) %name      ASTQFL, ASTQBL,
   %record(*) %name      PHYPCB,
   %record(PCB Fm) %name OWNER,
   %integer              WSSWP,
   %integer              STS,
 ( %integer              WTIME {no longer used} %or
   %byte                 PRISAV, PRIBSAV, UNU1, UNU2 ),
   %short                STATE,
   %byte                 WEFC, PRIB,
   %short                APTCNT,
   %short                TMBU,
   %short                GPGCNT, PPGCNT, ASTCNT, BIOCNT,
   %short                BIOLM,  DIOCNT, DIOLM,  PRCCNT,
   %string(7)            TERMINAL,
 ( %record(*) %name      PQB %or
   %integer              EFWM ),
   %integer              EFCS, EFCU,
   %integer %name        EFC2P, EFC3P,
   %integer              PID,
   %record(*) %name      PHD,
   %string(15)           LNAME,
   %record(*) %name      JIB,
   %integer              PRIV1, PRIV2,
   %record(*) %name      ARB,
 ( %integer              UIC %or
   %short                MEM, GRP ),
   %record(*) %name      LOCKQFL, LOCKQBL,
   %integer              DLCKPRI,
   %integer              IPAST -
)

!
! Values of bits in the STS longword
!
%const %integer PCB M RES         = 1<<0,  {resident, in balance set}
                PCB M DELPEN      = 1<<1,  {delete pending}
                PCB M FORCPEN     = 1<<2,  {force exit pending}
                PCB M INQUAN      = 1<<3,  {initial quantum in progress}
                PCB M PSWAPM      = 1<<4,  {process swap mode (1=noswap)}
                PCB M RESPEN      = 1<<5,  {resume pending; skip suspend}
                PCB M SSFEXC      = 1<<6,  {system service exception enable(K)}
                PCB M SSFEXCE     = 1<<7,  {system service exception enable(E)}
                PCB M SSFEXCS     = 1<<8,  {system service exception enable(S)}
                PCB M SSFEXCU     = 1<<9,  {system service exception enable(U)}
                PCB M SSRWAIT     = 1<<10  {system service resource wait enable}

%const %integer PCB M SUSPEN      = 1<<11, {suspend pending}
                PCB M WAKEPEN     = 1<<12, {wake pending; skip hibernate}
                PCB M WALL        = 1<<13, {wait for all events in mask}
                PCB M BATCH       = 1<<14, {process is a batch job}
                PCB M NOACNT      = 1<<15, {no accounting for process}
                PCB M SWPVBN      = 1<<16, {write for swap VBN in progress}
                PCB M ASTPEN      = 1<<17, {AST pending}
                PCB M PHDRES      = 1<<18, {process header resident}
                PCB M HIBER       = 1<<19, {hibernate after initial image act}
                PCB M LOGIN       = 1<<20  {login without reading UAF}

%const %integer PCB M NETWRK      = 1<<21, {process is a network connect object}
                PCB M PWRAST      = 1<<22, {power fail AST}
                PCB M NODELET     = 1<<23, {no delete}
                PCB M DISAWS      = 1<<24  {disable auto WS adjustment}
