!
! IMP equivalent of $PRDEF macro
!
! VAX processor registers
!
%const %integer %c
   PR KSP        = 16_00, {kernel stack pointer}
   PR ESP        = 16_01, {executive stack pointer}
   PR SSP        = 16_02, {supervisor stack pointer}
   PR USP        = 16_03, {user stack pointer}
   PR ISP        = 16_04, {interrupt stack pointer}
   PR P0BR       = 16_08, {P0 base register}
   PR P0LR       = 16_09, {P0 limit register}
   PR P1BR       = 16_0A, {P1 base register}
   PR P1LR       = 16_0B, {P1 limit register}
   PR SBR        = 16_0C, {system base register}
   PR SLR        = 16_0D, {system limit register}
   PR PCBB       = 16_10, {process control block base register}
   PR SCBB       = 16_11, {system control block base register}
   PR IPL        = 16_12, {interrupt priority level register}
   PR ASTLVL     = 16_13, {AST level register}
   PR SIRR       = 16_14, {software interrupt request register}
   PR SISR       = 16_15, {software interrupt summary register}
   PR CMIERR     = 16_17, {machine check status register}
   PR ICCS       = 16_18, {interval clock control status register}
   PR NICR       = 16_19, {interval clock next interval register}
   PR ICR        = 16_1A, {interval clock interval count register}
   PR TODR       = 16_1B, {time of day register}
   PR CSRS       = 16_1C, {console storage receive status register}
   PR CSRD       = 16_1D, {console storage receive data register}
   PR CSTS       = 16_1E, {console storage transmit status register}
   PR CSTD       = 16_1F, {console storage transmit data register}
   PR RXCS       = 16_20, {console receiver control status register}
   PR RXDB       = 16_21, {console receiver data buffer register}
   PR TXCS       = 16_22, {console transmit control status register}
   PR TXDB       = 16_23, {console transmit data buffer register}
   PR TBDR       = 16_24, {translation buffer disable register}
   PR CADR       = 16_25, {cache disable register}
   PR MCESR      = 16_26, {machine check error summary register}
   PR CAER       = 16_27, {cache error register}
   PR ACCS       = 16_28, {accelerator control status register}
   PR ACCR       = 16_29, {accelerator reserved}
   PR WCSA       = 16_2C, {WCS address register}
   PR WCSD       = 16_2D, {WCS data register}
   PR SBIFS      = 16_30, {SBI fault status register}
   PR SBIS       = 16_31, {SBI silo register}
   PR SBISC      = 16_32, {SBI comparator register}
   PR SBIMT      = 16_33, {SBI maintenance register}
   PR SBIER      = 16_34, {SBI error register}
   PR SBITA      = 16_35, {SBI timeout address register}
   PR SBIQC      = 16_36, {SBI quadword clear register}
   PR UBRESET    = 16_37, {initialize UNIBUS register}
   PR MAPEN      = 16_38, {mapping enable register}
   PR TBIA       = 16_39, {translation buffer invalidate all}
   PR TBIS       = 16_3A, {translation buffer invalidate single}
   PR PME        = 16_3D, {performance monitor enable}
   PR SID        = 16_3E  {system identification register}

!
! SID Register contents
!
! Bits 31..24 processor type
!      23..0  type-specific
!
! Types
!
%const %integer %c
         PR SID TYP780 = 1, {VAX-11/780}
         PR SID TYP750 = 2, {VAX-11/750}
         PR SID TYP7ZZ = 3,
         PR SID TYPMAX = 3

!
! 780-specific fields
!
! 31..24 processor type
! 23..15 ECO level
! 14..12 Plant
! 11..0  Serial number
!
!         PR$S_SID_ECO   = 00000008
!         PR$V_SID_ECO   = 00000010
!         PR$V_SID_PL    = 0000000C
!         PR$S_SID_PL    = 00000004
!         PR$V_SID_SN    = 00000000
!         PR$S_SID_SN    = 0000000C
!         PR$V_SID_TYPE  = 00000018
!         PR$S_SID_TYPE  = 00000008
!

%end %of %file
