@heading[Edinburgh University]
@heading[Department of Computer Science]
@heading[Imp Distribution]

This tape (or whatever) contains all the files neccessary to use the 
EUCSD IMP-77 Compiler.

This compiler has been developed by this department and copies are 
freely available on request to other educational establishments,
however Edinburgh University do not guarantee its performance,
correctness or suitablity for any use whatsoever.
We further cannot provide any kind of support for this product.
However it is used very heavily within this 
department and its has been found to be robust (student-proof even)
and efficient. Despite any of the above we are still keen to receive
any reports or suggestions about the product. These will be examined 
carefully and may be used in making new version of this system.

The distibution is usually in VMS backup save-set format but whatever the
format this should be marked clearly on the media. 

This file is called READ.ME and contains the installation instructions.

Because the method used for installation of this system will vary
from site to site depending on the operating conditions, the 
instructions are not in a command file. Instead a series of instructions
follow:
@newpage
@heading[EUCSD IMP SYSTEM INSTALLATION NOTES]

@begin(enumerate)

Create a directory where the IMP stuff will reside and restore the
backup save set there.

@begin(multiple)

Compiler

The compiler itself is invoked using a VMS .CLD file. 
The image field in IMP.CLD calls up the compiler. 
Edit this to point to where IMP.EXE is to reside. 
We have it in the directory pointed to by the logcial name IMP_INCLUDE.
(ie. in the same directory as it was read from the tape)

There are two options for implementing the .CLD file on your system.


@begin(enumerate)
Put $SET COMMAND IMP_INCLUDE:IMP in the login file of anyone wishing to use
the IMP system.  This patches the local copy of DCLTABLES this user has for
the duration of his session.

@begin(multiple)
Patch the system wide DCLTABLES using the command

$ SET COMMAND/tables=DCLTABLES/out=DCLTABLES IMP_INCLUDE:IMP

This patches SYS$LIBRARY:DCLTABLES permanently and should be used where IMP
is fairly widely used on a system. (The first method of patching on
login takes some time and can make logins tedious)
@end(multiple)
@end(enumerate)

The compiler needs to access the file PRIMDEF.IMP, it looks by default in 
the directory SYS$LIBRARY: If you want to put it elsewhere assign the logical
name IMP_PRIMS to the file (n.b. FILE not DIRECTORY)

@end(multiple)

@begin(multiple)
IMP Runtime Library

Again there are two options here:

@begin(enumerate)
@begin(multiple)
Users may link explicitly with the runtime library using the command

$ LINK myprog,SYS$LIBRARY:IMPRTL/OPT        (searches IMPRTL.EXE)

or a command file may be built to do this automatically.
@end(multiple)

@BEGIN(MULTIPLE)
Alterntively the IMP run time library may be built in as one of the
libraries that VMS searches automatically during a normal link.
To do this use the command:

$ LIBRARY SYS$LIBRARY:IMAGELIB SYS$LIBRARY:IMPRTL.EXE

This causes LINK to automatically search IMPRTL.EXE (via IMAGELIB.OLB)
for unresolved calls.
@END(MUTILPLE)
@END(ENUMERATE)

@BEGIN(MULTIPLE)
For programs that are to be exported it is desirable that they be
independent of any shared libraries on the system. To build such an image
use the command to specifically search IMPRTL.OLB and include the 
relevant code fragments in the image.

$ LINK/NOSYSSHR myprog,SYS$LIBRARY:IMPRTL/LIB

The files IMPRTL.OPT, IMPRTL.EXE and IMPRTL.OLB should be
copied to SYS$LIBRARY: before using any of the above commands.
@END(MULTIPLE)
@END(MULTIPLE)

@begin(multiple)
IMP Include Files

These should stay in the general imp directory but the logical name
IMP_INCLUDE: should point to this directory. The required files will
be accessed by the compiler.
IMP_INCLUDE may be declared either at system, group or process level.

These include files (*.INC) contain constant @u[or] external routine 
specifications. Most are only relevant if you are writing programs 
which require you to use VMS system intefaces. The most useful file is 
"MATHS.INC", which contains the specification for maths routines such 
as SIN, COS,TAN etc. These specs are included in the program by:

@begin(display)
%include "IMP_INCLUDE:MATHS.INC"
@end(display)
@end(multiple)

@begin(multiple)
IMP Help File

IMP.HLP should be incorporated into the VMS help file with the command:

$ LIBRARY/HELP SYS$HELP:HELPLIB IMP

@end(multiple)
@end(enumerate)

George Cleland

@value[date]

@newpage
@heading[Note on use of streams]

For those people familiar with EMAS IMP the following may be useful.

Stream allocation is by default:

          Stream 0     -  terminal

          Stream 1     -  terminal or currently selected stream

          Stream 2-15  -  null by default but can be defined

On EMAS, stream definition was accomplished by:

@begin(display)
          DEFINE (n,filename)
@end(display)

On VMS IMP this the corresponding statements are:

@begin(display)
          OPENINPUT   (n,filename)
          OPENOUTPUT  (n,filename)
@end(display)

Filename may be either a literal string or a string variable, 
representing an explict VMS file name or a VMS logical name.

On VMS both an input and output stream may have the same number, i.e. 
the file associated with input 1 is independent of the file associated 
with output 1
