!
! RMS definitions
!

%record %format Xab Dat Fm ( %byte Cod, Bln, %short spare1,
                             %record(*)%name nxt,
                             %short rvn, spare2,
                             %string(7) rdt, cdt, edt,
                             %string(11) spare3 )

%const %integer XAB DAT COD = 16_00000012,
                XAB DAT BLN = 16_00000024

%record %format Xab Pro Fm ( %byte Cod, Bln, %short Spare1,
                             %record(*)%name Nxt,
                             %short Pro, Spare2,
                           ( %short Mbm, Grp %or %integer Uic ) )

%const %integer XAB PRO COD = 16_00000013,
                XAB PRO BLN = 16_00000010

%const %integer XAB M NOREAD  = 16_00000001,
                XAB M NOWRITE = 16_00000002,
                XAB M NOEXE   = 16_00000004,
                XAB M NODEL   = 16_00000008

%const %integer XAB V SYS     = 16_00000000,
                XAB V OWN     = 16_00000004,
                XAB V GRP     = 16_00000008,
                XAB V WLD     = 16_0000000C

%record %format Xab All Fm ( %byte Cod, Bln, %short Spare1,
                             %record(*)%name nxt,
                             %byte aop, %string(6) spare2,
                             %integer alq,
                             %short deq, %byte bkz, %string(8) spare3 )

%const %integer XAB ALL COD = 16_00000014,
                XAB ALL BLN = 16_00000020

%record %format Xab Fhc Fm ( %byte Cod, Bln, %short Spare1,
                             %record(*)%name nxt,
                             %byte rfo, atr, %short lrl ,
                             %integer hbk, ebk,
                             %short ffb, %byte bkz, hsz,
                             %short mrz, dxq,
                             %string(11) spare2,
                             %integer sbn )

%const %integer XAB FHC COD = 16_0000001D,
                XAB FHC BLN = 16_0000002C

%record %format Xab Rdt Fm ( %byte Cod, Bln, %short Spare1,
                             %record(*)%name nxt,
                             %short rvn, spare2,
                             %string(7) rdt )

%const %integer XAB RDT COD = 16_0000001E,
                XAB RDT BLN = 16_00000014

%record %format Fid Fm ( %short Num, Seq, %byte Rvn, Nmx )

%record %format Nam Fm ( %byte Bid, Bln, Rss, Rsl,
                         %integer Rsa,
                         %byte Nop, Rfs, Ess, Esl,
                         %integer Esa,
                         %record(Nam Fm) %name Rlf,
                         %string(15) Dvi,
                         %record(Fid Fm) Fid, Did,
                         %integer wcc, fnb,
                         %byte Node Len, Dev Len, Dir Len, Name Len,
                         %byte Type Len, Ver Len, Unu1, Unu2,
                         %integer Node, Dev, Dir, Name, Type, Ver, Unu3, Unu4 )

%const %integer NAM BID    = 16_0002,
                NAM BLN    = 16_0060

%const %integer NAM C MAXRSS = 252

%const %integer NAM NOP PWD  = 1,
                NAM NOP ROD  = 2,
                NAM NOP SOD  = 4

%const %integer NAM RFS UFS      = 0,
                NAM RFS RMS11    = 1,
                NAM RFS RMS20    = 2,
                NAM RFS RMS32    = 3,
                NAM RFS FCS11    = 4,
                NAM RFS RT11FS   = 5,
                NAM RFS TOPS20FS = 7,
                NAM RFS TOPS10FS = 8

{wild card context field}
!!! $EQU   NAM$V_IFI   16
!!! $EQU   NAM$M_IFI   <^X10000>
!!! $EQU   NAM$V_SRCHNMF   30
!!! $EQU   NAM$M_SRCHNMF   <^X40000000>
!!! $EQU   NAM$V_SVCTX   31
!!! $EQU   NAM$M_SVCTX   <^X80000000>

%const %integer NAM FNB EXP VER         = 1<<0,
                NAM FNB EXP TYPE        = 1<<1,
                NAM FNB EXP NAME        = 1<<2,
                NAM FNB WILD VER        = 1<<3,
                NAM FNB WILD TYPE       = 1<<4,
                NAM FNB WILD NAME       = 1<<5,
                NAM FNB EXP DIR         = 1<<6,
                NAM FNB EXP DEV         = 1<<7,
                NAM FNB WILDCARD        = 1<<8,
                NAM FNB CNCL DEV        = 1<<12,
                NAM FNB ROOT DIR        = 1<<13,
                NAM FNB LOWVER          = 1<<14,
                NAM FNB HIGHVER         = 1<<15,
                NAM FNB PPF             = 1<<16,
                NAM FNB NODE            = 1<<17,
                NAM FNB QUOTED          = 1<<18,
                NAM FNB GRP MBR         = 1<<19,
                NAM FNB WILD DIR        = 1<<20,
                NAM FNB DIR LVLS        = 1<<21,
                NAM FNB WILD UFD        = 1<<24,
                NAM FNB WILD SFD1       = 1<<25,
                NAM FNB WILD SFD2       = 1<<26,
                NAM FNB WILD SFD3       = 1<<27,
                NAM FNB WILD SFD4       = 1<<28,
                NAM FNB WILD SFD5       = 1<<29,
                NAM FNB WILD SFD6       = 1<<30,
                NAM FNB WILD SFD7       = 1<<31,
                NAM FNB WILD GRP        = 1<<24,
                NAM FNB WILD MBR        = 1<<25

%record %format Fab Fm ( %byte bid, bln, %short ifi,
                         %integer fop, sts, stv, alq,
                         %short deq, %byte fac, shr,
                         %integer ctx,
                         %byte rtv, org, rat, rfm,
                         %integer jnl,
                         %record(*)%name xab,
                         %record(Nam Fm)%name nam,
                         %integer fna, dna,
                         %byte fns, dns, %short mrs,
                         %integer mrn,
                         %short bls, %byte bks, fsz,
                         %integer dev, sdc, spare1, spare2 )

%const %integer FAB BID    = 16_00000003, {block ID}
                FAB BLN     = 16_00000050  {length}

%const %integer FAB FOP MXV = 16_00000002, {maximise version}
                FAB FOP SUP = 16_00000004, {supercede on create}
                FAB FOP TMP = 16_00000008, {temporary}
                FAB FOP TMD = 16_00000010, {temporary, mark for delete}
                FAB FOP DFW = 16_00000020, {deferred write}
                FAB FOP SQO = 16_00000040, {sequential only}
                FAB FOP RWO = 16_00000080, {rewind on open}
                FAB FOP POS = 16_00000100, {current position}
                FAB FOP WCK = 16_00000200, {write-check}
                FAB FOP NEF = 16_00000400, {not end of file}
                FAB FOP RWC = 16_00000800, {rewind on close}
                FAB FOP DMO = 16_00001000, {???}
                FAB FOP SPL = 16_00002000, {spool}
                FAB FOP SCF = 16_00004000, {submit command file}
                FAB FOP DLT = 16_00008000, {delete on close}
                FAB FOP NFS = 16_00010000, {non-file-structured}
                FAB FOP UFO = 16_00020000, {user file open}
                FAB FOP PPF = 16_00040000, {process-permanent file}
                FAB FOP INP = 16_00080000, {file is SYS$INPUT}
                FAB FOP CTG = 16_00100000, {contiguous}
                FAB FOP CBT = 16_00200000, {contiguous-best-try}
                FAB FOP JNL = 16_00400000, {???}
                FAB FOP RCK = 16_00800000, {read-check}
                FAB FOP NAM = 16_01000000, {NAM block inputs}
                FAB FOP CIF = 16_02000000, {create-if}
                FAB FOP UFM = 16_04000000, {user file mode}
                FAB FOP ESC = 16_08000000, {nonstandard RMS processing}
                FAB FOP TEF = 16_10000000, {truncate at end of file}
                FAB FOP OFP = 16_20000000, {output file parse}
                FAB FOP KFO = 16_40000000  {known file open}

%const %integer FAB ORG SEQ = 16_00000000, {sequential}
                FAB ORG REL = 16_00000010, {relative}
                FAB ORG IDX = 16_00000020  {indexed}

%const %integer FAB FAC PUT = 16_00000001, {$PUT}
                FAB FAC GET = 16_00000002, {$GET}
                FAB FAC DEL = 16_00000004, {$DELETE}
                FAB FAC UPD = 16_00000008, {$UPDATE}
                FAB FAC TRN = 16_00000010, {$TRUNCATE}
                FAB FAC BIO = 16_00000020, {block i/o}
                FAB FAC BRO = 16_00000040  {block and record i/o}

%const %integer FAB RAT FTN = 16_00000001, {fortran carriage control}
                FAB RAT CR  = 16_00000002, {line feed/carriage return}
                FAB RAT PRN = 16_00000004, {print file}
                FAB RAT BLK = 16_00000008  {no block spanning by records}

%const %integer FAB RFM UDF = 16_00000000, {undefined}
                FAB RFM FIX = 16_00000001, {fixed-length}
                FAB RFM VAR = 16_00000002, {variable-length}
                FAB RFM VFC = 16_00000003, {variable + fixed control}
                FAB RFM STM = 16_00000004, {stream}
                FAB RFM STMLF = 5, {stream lf}
                FAB RFM STMCR = 6  {stream cr}
%const %integer FAB SHR PUT = 16_00000001, {$PUT}
                FAB SHR GET = 16_00000002, {$GET}
                FAB SHR DEL = 16_00000004, {$DELETE}
                FAB SHR UPD = 16_00000008, {$UPDATE}
                FAB SHR MSE = 16_00000010, {multi-stream access}
                FAB SHR NIL = 16_00000020, {no file sharing}
                FAB SHR UPI = 16_00000040  {many sequential block writers(!)}

%record %format Rab Fm ( %byte Bid, Bln, %short Isi,
                         %integer rop, sts, stv,
                         %short rfa1, rfa2, rfa3, spare1,
                         %integer ctx,
                         %short spare2, %byte rac, tmo,
                         %short usz, rsz,
                         %integer ubf, rbf,
                         %integer rhb,
                       ( %integer Kbf %or %integer Pbf ),
                       ( %byte    Ksz %or %byte    Psz ),
                         %byte spare3, mbf, mbc,
                         %integer bkt,
                         %record(Fab Fm) %name Fab,
                         %integer spare4 )

%const %integer RAB BID    = 16_00000001,
                RAB BLN     = 16_00000044

%const %integer RAB RAC SEQ = 16_00000000,
                RAB RAC KEY = 16_00000001,
                RAB RAC RFA = 16_00000002

%const %integer RAB ROP ASY = 16_00000001, {asynchronous}
                RAB ROP TPT = 16_00000002, {truncate on put}
                RAB ROP REA = 16_00000004, {lock record for read}
                RAB ROP RRL = 16_00000008, {read regardless of lock}
                RAB ROP UIF = 16_00000010, {update if}
                RAB ROP MAS = 16_00000020, {??}
                RAB ROP FDL = 16_00000040, {fast delete}
                RAB ROP HSH = 16_00000080, {??}
                RAB ROP EOF = 16_00000100, {end-of-file}
                RAB ROP RAH = 16_00000200, {read-ahead}
                RAB ROP WBH = 16_00000400, {write-behind}
                RAB ROP BIO = 16_00000800, {block i/o}
                RAB ROP LOA = 16_00002000, {load}
                RAB ROP LIM = 16_00004000, {limit}
                RAB ROP LOC = 16_00010000  {locate mode}
%const %integer RAB ROP WAT = 16_00020000, {wait for no lock}
                RAB ROP ULK = 16_00040000, {manual unlocking}
                RAB ROP RLK = 16_00080000, {lock record for write}
                RAB ROP NLK = 16_00100000, {no lock}
                RAB ROP KGE = 16_00200000, {key is greater than or equal to}
                RAB ROP KGT = 16_00400000, {key is greater than}
                RAB ROP NXR = 16_00800000, {nonexistent record processing}
                RAB ROP RNE = 16_01000000, {read no echo}
                RAB ROP TMO = 16_02000000, {timeout}
                RAB ROP CVT = 16_04000000, {convert}
                RAB ROP RNF = 16_08000000, {read no filter}
                RAB ROP PTA = 16_20000000, {purge type-ahead}
                RAB ROP PMT = 16_40000000, {prompt}
                RAB ROP CCO = 16_80000000  {cancel control-O}

%external %integer %function %spec Rms Close  %alias "SYS$CLOSE"            %c
                                            ( %record(Fab Fm) %name F )
%external %integer %function %spec Rms Create %alias "SYS$CREATE"           %c
                                            ( %record(Fab Fm) %name F )
%external %integer %function %spec Rms Erase  %alias "SYS$ERASE"            %c
                                            ( %record(Fab Fm) %name F )
%external %integer %function %spec Rms Open   %alias "SYS$OPEN"             %c
                                            ( %record(Fab Fm) %name F )
%external %integer %function %spec Rms Parse  %alias "SYS$PARSE"            %c
                                            ( %record(Fab Fm) %name F )
%external %integer %function %spec Rms Search %alias "SYS$SEARCH"           %c
                                            ( %record(Fab Fm) %name F )

%external %integer %function %spec Rms Connect    %alias "SYS$CONNECT"      %c
                                           ( %record(Rab Fm) %name R )
%external %integer %function %spec Rms Delete     %alias "SYS$DELETE"       %c
                                           ( %record(Rab Fm) %name R )
%external %integer %function %spec Rms Disconnect %alias "SYS$DISCONNECT"   %c
                                           ( %record(Rab Fm) %name R )
%external %integer %function %spec Rms Find       %alias "SYS$FIND"         %c
                                           ( %record(Rab Fm) %name R )
%external %integer %function %spec Rms Flush      %alias "SYS$FLUSH"        %c
                                           ( %record(Rab Fm) %name R )
%external %integer %function %spec Rms Free       %alias "SYS$FREE"         %c
                                           ( %record(Rab Fm) %name R )
%external %integer %function %spec Rms Get        %alias "SYS$GET"          %c
                                           ( %record(Rab Fm) %name R )
%external %integer %function %spec Rms Nxtvol     %alias "SYS$NXTVOL"       %c
                                           ( %record(Rab Fm) %name R )
%external %integer %function %spec Rms Put        %alias "SYS$PUT"          %c
                                           ( %record(Rab Fm) %name R )
%external %integer %function %spec Rms Release    %alias "SYS$RELEASE"      %c
                                           ( %record(Rab Fm) %name R )
%external %integer %function %spec Rms Rewind     %alias "SYS$REWIND"       %c
                                           ( %record(Rab Fm) %name R )
%external %integer %function %spec Rms Truncate   %alias "SYS$TRUNCATE"     %c
                                           ( %record(Rab Fm) %name R )
%external %integer %function %spec Rms Update     %alias "SYS$UPDATE"       %c
                                           ( %record(Rab Fm) %name R )
%external %integer %function %spec Rms Wait       %alias "SYS$WAIT"         %c
                                           ( %record(Rab Fm) %name R )
%external %integer %function %spec Rms Read       %alias "SYS$READ"         %c
                                           ( %record(Rab Fm) %name R )
%external %integer %function %spec Rms Write      %alias "SYS$WRITE"        %c
                                           ( %record(Rab Fm) %name R )

%external %routine %spec Rms Set DF Prot          %alias "SYS$SETDFPROT"    %c
                                           ( %short %name Old Default,
                                             %short %name New Default )

%end %of %file
