!
! >>> SYSIO.INC <<<
!
! System services for I/O
!
! I/O service specific record formats
!
%record %format IOSB Fm ( %short Status, Count, %integer DevDepend )

%record %format Dib Fm ( %c
      %integer Devchar,    {device characteristics}
      %byte Devclass, Devtype,
      %short Devbufsiz,
      ( %integer Devdepend %or
      %byte Sectors, Tracks, %short Cylinders ),
      %short Unit, Devnamoff,
      %integer Pid, Ownuic,
      %short Vprot, Errcnt,
      %integer Opcnt,
      %short Volnamoff, Recsiz,
      %string(75) Devname,
      %integer Maxblock )

!
! Procedures start here
!
%external %integer %function %spec ASSIGN %alias "IMP_ASSIGN" ( %c
            %string(63) Devnam, %short %name Chan,
            %integer Acmode, %string(63) Mbxnam )

%external %integer %function %spec ALLOC  %alias "IMP_ALLOC" ( %c
            %string(255) Devnam, %string(*) %name Phynam,
            %integer Acmode )

%external %integer %function %spec BRDCST %alias "IMP_BRDCST" ( %c
            %string(255) Message, Device, %integer Flags, Carcon )

%system %integer %function %spec CANCEL ( %integer Chan )

%external %integer %function %spec DALLOC %alias "IMP_DALLOC" ( %c
                   %string(255) DEVNAM, %integer ACMODE )

%system %integer %function %spec DASSGN ( %integer Chan )

%external %integer %function %spec GETCHN %alias "IMP_GETCHN" ( %c
            %integer Chan, %record(Dib Fm) %name Pri, Sec )

%external %integer %function %spec GETDEV %alias "IMP_GETDEV" ( %c
            %string(63) Device, %record(Dib Fm) %name Pri, Sec )

%external %integer %function %spec GETDVI %alias "IMP_GETDVI" ( %c
            %integer Efn, Chan, %string(255) Devnam,
            %record(*) %name Itmlst,
            %record(IOSB Fm) %name IOSB,
            %record(*) %name ASTADR, %integer ASTPRM,
            %integer DUMMY )

%external %integer %function %spec INPUT %alias "IMP_INPUT" ( %c
            %integer Chan, Length, Buffer,
            %record(IOSB Fm) %name IOSB, %integer Efn )

%external %integer %function %spec OUTPUT %alias "IMP_OUTPUT" ( %c
            %integer Chan, Length, Buffer,
            %record(IOSB Fm) %name IOSB, %integer Efn )

%system %integer %function %spec QIO                          ( %c
            %integer Efn, Chan, Func, %record(IOSB Fm) %name IOSB,
            %record(*) %name ASTADR, %integer ASTPRM,
            %integer P1, P2, P3, P4, P5, P6                   )

%system %integer %function %spec QIOW                         ( %c
            %integer Efn, Chan, Func, %record(IOSB Fm) %name IOSB,
            %record(*) %name ASTADR, %integer ASTPRM,
            %integer P1, P2, P3, P4, P5, P6                   )
